/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.pay.cash;

import java.util.Map;
import plfx.Options;
import plfx.input.keyboard.KeyboardListener;
import plfx.model.action.VoidActionNotifier;
import plfx.screen.FxScreenTemplate;
import plfx.screen.ScreenInit;
import plfx.screen.ScreenListener;
import plfx.screen.pay.ButtonActionListener;
import plfx.screen.pay.CommonSumScreen;
import plfx.screen.pay.SumData;
import plfx.screen.pay.cash.PayCashTemplate;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.screen.Event;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.input.model.screen.description.SumScreenDescription;

class PayCashScreen
implements CommonSumScreen {
    private PayCashTemplate tpl;
    private VoidActionNotifier notifier;

    public PayCashScreen(PayCashTemplate tpl) {
        if (tpl == null) {
            throw new NullPointerException("Template");
        }
        this.tpl = tpl;
        this.notifier = new VoidActionNotifier(this);
        tpl.getBackButton().setListener(new ButtonActionListener("prev", this.notifier));
        tpl.getExitButton().setListener(new ButtonActionListener("exit", this.notifier));
        tpl.getNextButton().setListener(new ButtonActionListener("next", this.notifier));
        tpl.getCbcButton().setListener(new ButtonActionListener("cbc", this.notifier));
        tpl.getCommButton().setListener(new ButtonActionListener("comm", this.notifier));
        tpl.getActions().forEach((a, b) -> b.setListener(() -> this.notifier.notify((String)a)));
    }

    @Override
    public void init(ScreenDescription sd, ScreenInit si) throws InitException {
        SumScreenDescription ssd;
        this.tpl.setAccount("");
        this.tpl.setFieldTitle("", "");
        String title = "id1";
        Map d = si.getModelEnvironment().getData();
        this.initTitle(d, title);
        if (sd instanceof SumScreenDescription && (ssd = (SumScreenDescription)sd).getScreenTitle() != null && !ssd.getScreenTitle().isEmpty()) {
            title = ssd.getScreenTitle();
        }
        this.initTitle(d, title);
        this.notifier.init();
        this.tpl.setServiceLogo(sd.getIcon(), sd.getStyleClass());
    }

    private void initTitle(Map<String, Object> d, String title) {
        Object obj;
        if (!d.isEmpty() && (obj = d.get(title)) instanceof InputElement) {
            InputElement ie = (InputElement)obj;
            this.tpl.setFieldTitle(ie.getKeyTitleId(), ie.getKeyTitle());
            this.tpl.setAccount(ie.getValueTitle());
        }
    }

    @Override
    public void updateSums(SumData data) {
        this.tpl.getBackButton().setDisable(!data.isCanBack());
        this.tpl.getNextButton().setDisable(!data.isCanPay());
        this.tpl.getExitButton().setDisable(!data.isCanExit());
    }

    @Override
    public void setListener(ScreenListener listener) {
        this.notifier.setListener(listener);
    }

    @Override
    public KeyboardListener getKeyboardListener() {
        return null;
    }

    @Override
    public FxScreenTemplate getTemplate() {
        return this.tpl;
    }

    @Override
    public void onEvent(Event event) {
        Options.GUI.info((Object)("Event " + event + " in PayCashScreen is ignored"));
    }
}

