/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.pay.cash;

import java.lang.reflect.Constructor;
import java.util.Properties;
import plfx.GuiNotifier;
import plfx.element.FxInitException;
import plfx.screen.ScreenCreateException;
import plfx.screen.pay.CommonSumScreen;
import plfx.screen.pay.SumScreenFactory;
import plfx.screen.pay.cash.DefaultCashTemplate;
import plfx.screen.pay.cash.PayCashScreen;
import plfx.screen.pay.cash.PayCashTemplate;
import plfx.util.LoadTemplateException;
import plfx.util.Locator;
import plfx.util.ResourceLoader;

public class DefaultCashFactory
implements SumScreenFactory {
    @Override
    public CommonSumScreen create(String path, Properties prop) throws ScreenCreateException {
        try {
            PayCashTemplate template = null;
            String controller = prop.getProperty("controller", "");
            if (!controller.isEmpty()) {
                try {
                    Constructor<?> c = Class.forName(controller).getConstructor(String.class);
                    template = (PayCashTemplate)c.newInstance("screen.pay." + path);
                }
                catch (Throwable throwable) {
                    GuiNotifier.notifyError(throwable);
                    template = new DefaultCashTemplate("screen.pay." + path);
                }
            } else {
                template = new DefaultCashTemplate("screen.pay." + path);
            }
            ResourceLoader.load(Locator.getUrl("/gui/skin/{name}//screen/pay/" + path + "/template.fxml"), template);
            template.init();
            CommonSumScreen screen = null;
            String screenName = prop.getProperty("screen", "");
            if (!screenName.isEmpty()) {
                try {
                    Constructor<?> c = Class.forName(screenName).getConstructor(PayCashTemplate.class);
                    screen = (CommonSumScreen)c.newInstance(template);
                }
                catch (Throwable throwable) {
                    GuiNotifier.notifyError(throwable);
                    screen = new PayCashScreen(template);
                }
            } else {
                screen = new PayCashScreen(template);
            }
            return screen;
        }
        catch (FxInitException | LoadTemplateException ex) {
            GuiNotifier.notifyError(ex);
            throw new ScreenCreateException("Error on create sum screen: " + path, ex);
        }
    }
}

