/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.pay;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javafx.fxml.FXML;
import javafx.scene.layout.Pane;
import plfx.element.FxInitException;
import plfx.element.SButton;
import plfx.element.SLabel;
import plfx.navigation.GuiNavigation;
import plfx.screen.BaseFxScreenTemplate;
import plfx.screen.menu.MenuTemplateController;
import plfx.screen.menu.MenuTemplateListener;
import plfx.screen.pay.InputTemplate;
import ru.softlogic.input.model.screen.ActionType;
import ru.softlogic.input.model.screen.ButtonInit;

public abstract class InputTemplateImpl
extends BaseFxScreenTemplate
implements InputTemplate {
    protected SButton backBtn;
    protected SButton exitBtn;
    protected SButton nextBtn;
    protected SButton extraBtn;
    protected SButton commBtn;
    private Pane logoPane;
    private Set<String> styles;
    private SLabel serviceName;
    @FXML
    protected MenuTemplateController headerController;
    @FXML
    protected MenuTemplateController footerController;
    @FXML
    protected GuiNavigation naviController;

    public InputTemplateImpl(String screenId, String bundleId) {
        super(screenId, bundleId);
    }

    @Override
    public void init() throws FxInitException {
        super.init();
        this.backBtn = this.searchButton("backButton");
        this.exitBtn = this.searchButton("exitButton");
        this.nextBtn = this.searchButton("nextButton");
        this.extraBtn = this.searchButton("extraButton");
        this.commBtn = this.searchButton("commButton");
        this.logoPane = (Pane)this.searchNode("#logoPane");
        this.serviceName = this.searchScreenLabel("serviceName", true);
        if (this.logoPane != null) {
            this.styles = new HashSet<String>();
            this.styles.addAll((Collection<String>)this.logoPane.getStyleClass());
        }
    }

    @Override
    public SButton getNextButton() {
        return this.nextBtn;
    }

    @Override
    public SButton getBackButton() {
        return this.backBtn;
    }

    @Override
    public SButton getExitButton() {
        return this.exitBtn;
    }

    @Override
    public SButton getExtraButton() {
        return this.extraBtn;
    }

    @Override
    public SButton getCommButton() {
        return this.commBtn;
    }

    @Override
    public void setServiceLogo(String logoPath, String styleClass) {
        if (this.logoPane != null) {
            if (logoPath != null) {
                this.logoPane.setStyle("-fx-background-image: url('" + logoPath + "');");
                this.serviceName.setVisible(false);
                this.logoPane.setVisible(true);
            } else {
                this.logoPane.setStyle(null);
                this.logoPane.setVisible(false);
                this.serviceName.setVisible(true);
            }
            this.logoPane.getStyleClass().clear();
            this.logoPane.getStyleClass().addAll(this.styles);
            if (styleClass != null && !styleClass.isEmpty()) {
                this.logoPane.getStyleClass().add((Object)styleClass);
            }
        }
    }

    @Override
    public void setListener(MenuTemplateListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.headerController != null) {
            this.headerController.setListener(listener);
        }
        if (this.footerController != null) {
            this.footerController.setListener(listener);
        }
    }

    @Override
    public GuiNavigation getNavigation() {
        return this.naviController;
    }

    @Override
    public void initButtons(Map<String, ButtonInit> buttons) {
        if (buttons != null) {
            this.nextBtn.setDisable(true);
            this.exitBtn.setDisable(true);
            this.backBtn.setDisable(true);
            buttons.forEach((button, u) -> {
                if (ActionType.isNext((String)button)) {
                    this.nextBtn.setDisable(false);
                }
                if (ActionType.isPrev((String)button)) {
                    this.backBtn.setDisable(false);
                }
                if (ActionType.isExit((String)button)) {
                    this.exitBtn.setDisable(false);
                }
            });
        }
    }
}

