/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.offer;

import java.lang.reflect.Constructor;
import java.util.Properties;
import plfx.GuiNotifier;
import plfx.element.FxInitException;
import plfx.screen.ScreenCreateException;
import plfx.screen.offer.DefaultOfferScreen;
import plfx.screen.offer.DefaultOfferTemplate;
import plfx.screen.offer.OfferScreen;
import plfx.screen.offer.OfferTemplate;
import plfx.util.LoadTemplateException;
import plfx.util.Locator;
import plfx.util.ResourceLoader;

public class OfferFactory {
    private OfferFactory() {
    }

    public static OfferScreen createOfferScreen() throws ScreenCreateException {
        String path = "/gui/skin/{name}//screen/offer/template.fxml";
        try {
            OfferScreen screen;
            OfferTemplate template;
            Properties prop = Locator.readQuietly("/gui/skin/{name}//screen/offer/descriptor.properties", false);
            String controller = prop.getProperty("controller", "");
            if (!controller.isEmpty()) {
                try {
                    template = (OfferTemplate)Class.forName(controller).newInstance();
                }
                catch (Throwable throwable) {
                    GuiNotifier.notifyError(throwable);
                    template = new DefaultOfferTemplate();
                }
            } else {
                template = new DefaultOfferTemplate();
            }
            ResourceLoader.load(Locator.getUrl(path), template);
            template.init();
            String screenName = prop.getProperty("screen", "");
            if (!screenName.isEmpty()) {
                try {
                    Constructor<?> c = Class.forName(screenName).getConstructor(OfferTemplate.class);
                    screen = (OfferScreen)c.newInstance(template);
                }
                catch (Throwable throwable) {
                    GuiNotifier.notifyError(throwable);
                    screen = new DefaultOfferScreen(template);
                }
            } else {
                screen = new DefaultOfferScreen(template);
            }
            return screen;
        }
        catch (FxInitException | LoadTemplateException ex) {
            GuiNotifier.notifyError(ex);
            throw new ScreenCreateException("Erron on create offer screen " + path, ex);
        }
    }
}

