/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.offer;

import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReentrantLock;
import javafx.concurrent.Worker;
import plfx.element.ButtonListener;
import plfx.screen.FxScreenTemplate;
import plfx.screen.offer.OfferScreen;
import plfx.screen.offer.OfferScreenListener;
import plfx.screen.offer.OfferTemplate;
import plfx.util.TerminalPlatform;

public class DefaultOfferScreen
implements OfferScreen {
    protected OfferScreenListener listener;
    private OfferTemplate template;
    private ReentrantLock lock = new ReentrantLock();
    private boolean load;

    public DefaultOfferScreen(OfferTemplate template) {
        if (template == null) {
            throw new NullPointerException("OfferTemplate");
        }
        this.template = template;
        template.getCloseButton().setListener(new CloseListener());
        template.getBackButton().setListener(new BackListener());
        template.getWebView().getEngine().getLoadWorker().stateProperty().addListener((ov, oldState, newState) -> {
            if (newState == Worker.State.SUCCEEDED && this.load) {
                template.getWaitPane().setVisible(false);
                this.lock.unlock();
                this.load = false;
            }
        });
    }

    @Override
    public void setListener(OfferScreenListener listener) {
        this.listener = listener;
        this.template.setListener(listener);
    }

    @Override
    public FxScreenTemplate getTemplate() {
        return this.template;
    }

    @Override
    public void setContent(Callable<String> loadcontent) {
        if (!this.lock.tryLock()) {
            return;
        }
        this.template.getWebView().getEngine().loadContent("");
        this.template.getWaitPane().setVisible(true);
        new Thread(() -> {
            try {
                String result = (String)loadcontent.call();
                TerminalPlatform.runLater(() -> {
                    this.load = true;
                    this.template.getWebView().getEngine().loadContent(result);
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }).start();
    }

    private class BackListener
    implements ButtonListener {
        private BackListener() {
        }

        @Override
        public void onAction() {
            if (DefaultOfferScreen.this.listener != null) {
                DefaultOfferScreen.this.listener.onBack();
            }
        }
    }

    private class CloseListener
    implements ButtonListener {
        private CloseListener() {
        }

        @Override
        public void onAction() {
            if (DefaultOfferScreen.this.listener != null) {
                DefaultOfferScreen.this.listener.onExit();
            }
        }
    }
}

