/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.menu.button;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import plfx.screen.menu.button.BaseMenuButton;

public class TagComplexMenuButton
extends BaseMenuButton
implements EventHandler<MouseEvent> {
    private static final String SIZE_PROP = "sizeSuffix";
    private final Node tag;
    private final Label comm;
    private final Pane rootPane;
    private final Pane btnContentPane;
    private final String template;
    private final String type;
    private Node image;
    private Label title;
    private Label hint;
    private List<String> defaultStyles;
    private boolean labelvisible;
    private String tagSize;

    public TagComplexMenuButton(Pane pane, String template, String type) {
        if (pane == null) {
            throw new NullPointerException("Pane is null");
        }
        this.rootPane = pane;
        this.btnContentPane = (Pane)this.rootPane.lookup(".button-content");
        this.template = template;
        this.type = type;
        if (this.btnContentPane == null) {
            throw new NullPointerException("Pane button-content is null");
        }
        this.defaultStyles = new LinkedList<String>();
        this.defaultStyles.addAll((Collection<String>)this.btnContentPane.getStyleClass());
        this.btnContentPane.setOnMouseClicked((EventHandler)this);
        this.image = this.btnContentPane.lookup(".button-image");
        this.title = (Label)this.btnContentPane.lookup(".button-label");
        this.hint = (Label)this.btnContentPane.lookup(".button-desc");
        Object obj = this.btnContentPane.getProperties().get((Object)"label-visible");
        if (obj != null && obj instanceof String) {
            this.labelvisible = "true".equalsIgnoreCase((String)obj);
        }
        this.tag = this.rootPane.lookup(".button-tag");
        if (this.tag != null && (obj = this.tag.getProperties().get((Object)SIZE_PROP)) instanceof String) {
            this.tagSize = (String)obj;
        }
        this.comm = (Label)this.rootPane.lookup(".button-comm");
    }

    @Override
    public void setComm(String commValue) {
        if (this.comm != null) {
            if (commValue != null && !commValue.trim().isEmpty()) {
                this.comm.setText(commValue.trim());
                this.comm.setVisible(true);
            } else {
                this.comm.setText("");
                this.comm.setVisible(false);
            }
        }
    }

    @Override
    public void setTag(String path) {
        if (this.tag != null) {
            if (path != null) {
                this.tag.setStyle("-fx-background-image: url(\"" + path + "\");");
            } else {
                this.tag.setStyle("");
            }
        }
    }

    @Override
    public String getTagSize() {
        return this.tagSize;
    }

    @Override
    public void resetStyles() {
        this.btnContentPane.getStyleClass().clear();
        this.btnContentPane.getStyleClass().addAll(this.defaultStyles);
    }

    @Override
    public void addStyleClass(String style) {
        if (style == null) {
            throw new NullPointerException("Style is not set");
        }
        this.btnContentPane.getStyleClass().add((Object)style);
    }

    @Override
    public void setLogo(String path) {
        if (this.image != null) {
            if (path != null) {
                this.image.setStyle("-fx-background-image: url(\"" + path + "\");");
            } else {
                this.image.setStyle("");
                this.addStyleClass(this.type + "-noimage");
            }
        }
        if (this.title != null) {
            this.title.setVisible(true);
            if (path != null) {
                this.title.setVisible(this.labelvisible);
            }
        }
    }

    @Override
    public void setHint(String text) {
        if (this.hint != null) {
            this.hint.setText(text);
        }
    }

    @Override
    public void setLocked(boolean locked) {
        this.rootPane.setDisable(locked);
    }

    @Override
    public void setVisible(boolean visible) {
        this.rootPane.setVisible(visible);
    }

    @Override
    public Parent getParent() {
        return this.rootPane;
    }

    @Override
    public String getMessageTemplate() {
        return this.template;
    }

    @Override
    public void setText(String text) {
        if (this.title != null) {
            this.title.setText(text);
        }
    }

    public void handle(MouseEvent event) {
        this._doClick();
    }
}

