/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.menu.button;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import plfx.screen.menu.button.BaseMenuButton;
import plfx.screen.menu.button.ImageFactory;

public class SimpleMenuButton
extends BaseMenuButton
implements EventHandler<ActionEvent> {
    private final Button button;
    private final List<String> defaultStyles;
    private final ImageView imageView;
    private final String template;
    private final String type;

    public SimpleMenuButton(Button button, String template, String type) {
        this.button = button;
        this.template = template;
        this.type = type;
        this.button.setOnAction((EventHandler)this);
        this.button.setMaxSize(1000.0, 1000.0);
        this.defaultStyles = new LinkedList<String>();
        this.defaultStyles.addAll((Collection<String>)button.getStyleClass());
        this.imageView = new ImageView();
        this.imageView.setSmooth(true);
        this.imageView.setPreserveRatio(true);
        this.imageView.getStyleClass().add((Object)"button-image");
        button.graphicProperty().set((Object)this.imageView);
        DoubleBinding hb = button.heightProperty().multiply(0.88);
        this.imageView.fitHeightProperty().bind((ObservableValue)hb);
        DoubleBinding wb = button.widthProperty().multiply(0.88);
        this.imageView.fitWidthProperty().bind((ObservableValue)wb);
    }

    @Override
    public void resetStyles() {
        this.button.getStyleClass().clear();
        this.button.getStyleClass().addAll(this.defaultStyles);
    }

    @Override
    public void addStyleClass(String style) {
        if (style == null) {
            throw new NullPointerException("Style is not set");
        }
        this.button.getStyleClass().add((Object)style);
    }

    @Override
    public void setLogo(String path) {
        Image image = ImageFactory.getImage(path);
        this.imageView.setVisible(image != null);
        this.imageView.setImage(image);
        if (image == null) {
            this.addStyleClass(this.type + "-noimage");
        }
    }

    @Override
    public void setHint(String text) {
    }

    @Override
    public void setLocked(boolean locked) {
        this.button.setDisable(locked);
    }

    @Override
    public Parent getParent() {
        return this.button;
    }

    public String toString() {
        return "SimpleMenuButton{button=" + this.button + '}';
    }

    public void handle(ActionEvent t) {
        this._doClick();
    }

    @Override
    public void setVisible(boolean visible) {
        this.button.setVisible(visible);
    }

    @Override
    public String getMessageTemplate() {
        return this.template;
    }

    @Override
    public void setText(String text) {
        this.button.setText(text);
    }

    public Button getButton() {
        return this.button;
    }
}

