/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.menu.button;

import javafx.scene.image.Image;
import plfx.util.Cache;

class ImageFactory {
    private static final ImageCache cache = new ImageCache();

    ImageFactory() {
    }

    public static Image getImage(String path) {
        return (Image)cache.getObject(path);
    }

    private static class ImageCache
    extends Cache<Image> {
        private ImageCache() {
        }

        @Override
        protected Image load(String path) {
            this.log.debug((Object)("Load from disk: " + path));
            try {
                return new Image(path);
            }
            catch (Exception ex) {
                this.log.error((Object)("Error on load image: " + path), (Throwable)ex);
                return null;
            }
        }
    }
}

