/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.menu.button;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import plfx.screen.menu.button.BaseMenuButton;

public class ComplexMenuButton
extends BaseMenuButton
implements EventHandler<MouseEvent> {
    private final Pane pane;
    private final String template;
    private final String type;
    private Node image;
    private Label title;
    private Label hint;
    private List<String> defaultStyles;
    private boolean labelvisible;

    public ComplexMenuButton(Pane pane, String template, String type) {
        if (pane == null) {
            throw new NullPointerException("Pane is null");
        }
        this.pane = pane;
        this.template = template;
        this.type = type;
        this.defaultStyles = new LinkedList<String>();
        this.defaultStyles.addAll((Collection<String>)pane.getStyleClass());
        pane.setOnMouseClicked((EventHandler)this);
        this.image = pane.lookup(".button-image");
        this.title = (Label)pane.lookup(".button-label");
        this.hint = (Label)pane.lookup(".button-desc");
        Object obj = pane.getProperties().get((Object)"label-visible");
        if (obj != null && obj instanceof String) {
            this.labelvisible = "true".equalsIgnoreCase((String)obj);
        }
    }

    @Override
    public void resetStyles() {
        this.pane.getStyleClass().clear();
        this.pane.getStyleClass().addAll(this.defaultStyles);
    }

    @Override
    public void addStyleClass(String style) {
        if (style == null) {
            throw new NullPointerException("Style is not set");
        }
        this.pane.getStyleClass().add((Object)style);
    }

    @Override
    public void setLogo(String path) {
        if (this.image != null) {
            if (path != null) {
                this.image.setStyle("-fx-background-image: url(\"" + path + "\");");
            } else {
                this.image.setStyle("");
                this.addStyleClass(this.type + "-noimage");
            }
        }
        if (this.title != null) {
            this.title.setVisible(true);
            if (path != null) {
                this.title.setVisible(this.labelvisible);
            }
        }
    }

    @Override
    public void setHint(String text) {
        if (this.hint != null) {
            this.hint.setText(text);
        }
    }

    @Override
    public void setLocked(boolean locked) {
        this.pane.setDisable(locked);
    }

    @Override
    public void setVisible(boolean visible) {
        this.pane.setVisible(visible);
    }

    @Override
    public Parent getParent() {
        return this.pane;
    }

    @Override
    public String getMessageTemplate() {
        return this.template;
    }

    @Override
    public void setText(String text) {
        if (this.title != null) {
            this.title.setText(text);
        }
    }

    public void handle(MouseEvent t) {
        this._doClick();
    }
}

