/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.menu.area;

import java.util.List;
import java.util.Map;
import java.util.Set;
import plfx.GuiNotifier;
import plfx.screen.menu.area.ButtonArea;
import plfx.screen.menu.button.MenuButton;
import plfx.screen.menu.button.MenuButtonInit;
import plfx.util.Locator;

public class ListButtonArea
implements ButtonArea {
    private List<MenuButton> buttons;
    private List<MenuButtonInit> inits;
    private String defaultStyleClass;
    private Set<String> styles;

    public ListButtonArea(List<MenuButton> buttons, String defaultStyleClass, Set<String> styles) {
        if (buttons == null) {
            throw new NullPointerException("List");
        }
        if (defaultStyleClass == null) {
            throw new NullPointerException("DefaultStyleClass");
        }
        if (styles == null) {
            throw new NullPointerException("Styles");
        }
        this.buttons = buttons;
        this.defaultStyleClass = defaultStyleClass;
        this.styles = styles;
    }

    @Override
    public int getCapacity() {
        return this.buttons.size();
    }

    @Override
    public void fill(List<MenuButtonInit> inits) {
        if (inits == null) {
            throw new NullPointerException("Inits");
        }
        this.inits = inits;
        for (MenuButton mb : this.buttons) {
            mb.setVisible(false);
        }
        for (int i = 0; i < this.buttons.size() && i < inits.size(); ++i) {
            MenuButtonInit mbi = inits.get(i);
            MenuButton mb = this.buttons.get(i);
            mb.setListener(mbi.getListener());
            mb.setVisible(true);
            mb.setLocked(mbi.isDisable());
            mb.resetStyles();
            if (this.styles.contains(mbi.getStyleClass())) {
                mb.addStyleClass(mbi.getStyleClass());
            } else {
                if (mbi.getStyleClass() != null && !mbi.getStyleClass().isEmpty()) {
                    GuiNotifier.notifyProblemOnce("Button style " + mbi.getStyleClass() + " is not found");
                }
                mb.addStyleClass(this.defaultStyleClass);
            }
            mb.setLogo(this.processImagePath(mbi.getLogo()));
            mb.setTag(this.processTagImagePath(mbi, mb.getTagSize()));
            mb.setComm(mbi.getComm());
        }
    }

    private String processImagePath(String path) {
        return path == null || path.isEmpty() ? null : Locator.getPath("/gui/skin/{name}/img/" + path);
    }

    private String processTagImagePath(MenuButtonInit mbi, String size) {
        Map<String, String> tags = mbi.getTag();
        if (tags == null || tags.isEmpty()) {
            return null;
        }
        String res = this.processImagePath(tags.get(size));
        if (res == null) {
            res = this.processImagePath(tags.get("default"));
        }
        return res;
    }

    @Override
    public List<MenuButtonInit> getInits() {
        return this.inits;
    }
}

