/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.menu;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import plfx.Options;

public class StyleExtractor {
    private static final Logger log = Options.GUI;
    private static final Map<String, Set<String>> stylesCache = new HashMap<String, Set<String>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> extractStyles(String url) {
        log.info((Object)("Get styles: " + url));
        Set<String> data = stylesCache.get(url);
        if (data == null) {
            log.info((Object)"Styles not extracted before. Try extract styles");
            data = new HashSet<String>();
            InputStream is = null;
            try {
                is = new URL(url).openStream();
                List strs = IOUtils.readLines((InputStream)is);
                StringBuilder sb = new StringBuilder(",");
                for (String str : strs) {
                    if (str.trim().startsWith("//")) continue;
                    sb.append(str);
                }
                String content = sb.toString();
                content = content.replace("\t", "").replace("\n", "").replace("\r", "").replaceAll("/\\*+/", "").replaceAll("(\\{[^\\{]+\\})", ",").replaceAll(" ", "");
                Matcher m = Pattern.compile(",\\.([a-zA-Z_\\-\\d]+),").matcher(content);
                while (m.find()) {
                    String style = m.group(1);
                    data.add(style);
                }
                stylesCache.put(url, data);
            }
            catch (IOException ex) {
                try {
                    log.error((Object)"Error on extract styles", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)is);
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        log.info((Object)("Result: " + data));
        return data;
    }
}

