/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.menu;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import plfx.controller.lang.LangController;
import plfx.controller.page.PageController;
import plfx.screen.menu.MenuTemplateListener;

public class MenuTemplateController
implements Initializable {
    private MenuTemplateListener listener;
    @FXML
    private PageController pageController;
    @FXML
    private LangController langController;

    public void initialize(URL url, ResourceBundle rb) {
    }

    public void setListener(MenuTemplateListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listener = listener;
    }

    @FXML
    private void onPaymentState() {
        if (this.listener != null) {
            this.listener.onPaymentState();
        }
    }

    @FXML
    private void onSearchService() {
        if (this.listener != null) {
            this.listener.onSearchService();
        }
    }

    @FXML
    private void onCheckCopy() {
        if (this.listener != null) {
            this.listener.onCheckCopy();
        }
    }

    @FXML
    private void onHelp() {
        if (this.listener != null) {
            this.listener.onHelp();
        }
    }

    @FXML
    private void onOffer(ActionEvent event) {
        if (this.listener != null) {
            Node source = (Node)event.getSource();
            Object obj = source.getProperties().get((Object)"file");
            if (obj != null && obj instanceof String) {
                this.listener.onOffer((String)obj);
            } else {
                this.listener.onOffer(null);
            }
        }
    }

    @FXML
    private void onExit() {
        if (this.listener != null) {
            this.listener.onExit();
        }
    }

    @FXML
    private void onBack() {
        if (this.listener != null) {
            this.listener.onBack();
        }
    }

    @FXML
    protected void setLang(ActionEvent event) {
        String lang;
        Button b;
        Object obj;
        if (this.listener != null && (obj = (b = (Button)event.getSource()).getProperties().get((Object)"lang")) != null && obj instanceof String && (lang = (String)obj).matches("[a-z]{2}")) {
            this.listener.onSelectLang(lang);
        }
    }

    @FXML
    private void onSelectLang() {
        if (this.listener != null) {
            this.listener.onSelectLang();
        }
    }

    public PageController getPageController() {
        return this.pageController;
    }

    public LangController getLangController() {
        return this.langController;
    }
}

