/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.menu;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javafx.scene.layout.Pane;
import plfx.element.FxInitException;
import plfx.screen.menu.BaseMenuTemplate;
import plfx.screen.menu.StyleExtractor;
import plfx.screen.menu.area.ButtonArea;
import plfx.screen.menu.area.ListButtonArea;
import plfx.screen.menu.button.MenuButton;

public class DefaultMenuTemplate
extends BaseMenuTemplate {
    private final List<MenuButton> hotButtons;
    private final List<MenuButton> groupButtons;
    private final List<MenuButton> serviceButtons;
    private final List<MenuButton> mixedButtons;
    private final List<MenuButton> prevgroupButtons;
    private final ButtonArea hotArea;
    private final ButtonArea groupArea;
    private final ButtonArea serviceArea;
    private final ButtonArea mixedArea;
    private final ButtonArea prevgroupArea;
    private final Set<String> styles = new HashSet<String>();
    protected Pane groupLogo;

    public DefaultMenuTemplate(String screenId) {
        super(screenId);
        this.styles.add("light");
        this.styles.add("dark");
        this.styles.add("black");
        this.styles.add("white");
        this.styles.add("default-prevgroup-pressed");
        this.hotButtons = new LinkedList<MenuButton>();
        this.hotArea = new ListButtonArea(this.hotButtons, "default-hot", this.styles);
        this.groupButtons = new LinkedList<MenuButton>();
        this.groupArea = new ListButtonArea(this.groupButtons, "default-group", this.styles);
        this.prevgroupButtons = new LinkedList<MenuButton>();
        this.prevgroupArea = new ListButtonArea(this.prevgroupButtons, "default-prevgroup", this.styles);
        this.serviceButtons = new LinkedList<MenuButton>();
        this.serviceArea = new ListButtonArea(this.serviceButtons, "default-service", this.styles);
        this.mixedButtons = new LinkedList<MenuButton>();
        this.mixedArea = new ListButtonArea(this.mixedButtons, "default-mixed", this.styles);
    }

    @Override
    public void init() throws FxInitException {
        super.init();
        this.fill(this.hotButtons, "hot");
        this.fill(this.groupButtons, "group");
        this.fill(this.serviceButtons, "service");
        this.fill(this.mixedButtons, "mixed");
        this.fill(this.prevgroupButtons, "prevgroup");
    }

    @Override
    public ButtonArea getHotArea() {
        return this.hotArea;
    }

    @Override
    public ButtonArea getServiceArea() {
        return this.serviceArea;
    }

    @Override
    public ButtonArea getGroupArea() {
        return this.groupArea;
    }

    @Override
    public ButtonArea getPrevGroupArea() {
        return this.prevgroupArea;
    }

    @Override
    public ButtonArea getMixedArea() {
        return this.mixedArea;
    }

    private void fill(List<MenuButton> list, String prefix) throws FxInitException {
        MenuButton mb;
        for (int i = 0; i < 30 && (mb = this.searchMenuButton(prefix + i, prefix)) != null; ++i) {
            list.add(mb);
        }
    }

    @Override
    public void addUserStylesheet(String url) {
        this.styles.addAll(StyleExtractor.extractStyles(url));
        this.getPane().getStylesheets().add((Object)url);
    }

    @Override
    public String toString() {
        return "DefaultMenuTemplate{}";
    }
}

