/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.menu;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Properties;
import plfx.GuiNotifier;
import plfx.element.FxInitException;
import plfx.screen.TemplateCreateException;
import plfx.screen.menu.BaseMenuTemplate;
import plfx.screen.menu.DefaultMenuTemplate;
import plfx.screen.menu.MenuFactory;
import plfx.screen.menu.MenuTemplate;
import plfx.util.LoadTemplateException;
import plfx.util.Locator;
import plfx.util.ResourceLoader;

public class DefaultMenuFactory
implements MenuFactory {
    @Override
    public MenuTemplate create(String path, Properties prop) throws TemplateCreateException {
        try {
            String fpath;
            URL url;
            BaseMenuTemplate template;
            String controller = prop.getProperty("controller", "");
            if (!controller.isEmpty()) {
                try {
                    Constructor<?> c = Class.forName(controller).getConstructor(String.class);
                    template = (BaseMenuTemplate)c.newInstance(path);
                }
                catch (IllegalArgumentException | ReflectiveOperationException | SecurityException throwable) {
                    template = new DefaultMenuTemplate(path);
                }
            } else {
                template = new DefaultMenuTemplate(path);
            }
            if ((url = Locator.getFileUrl(fpath = "/gui/skin/{name}//screen/menu/" + path + "/template.fxml")) == null) {
                throw new LoadTemplateException(fpath + " is not exist");
            }
            ResourceLoader.load(url, template);
            template.init();
            url = Locator.getUrl("/gui/skin/{name}/css/menu.css");
            if (url != null) {
                template.addUserStylesheet(url.toExternalForm());
            }
            return template;
        }
        catch (FxInitException | LoadTemplateException ex) {
            GuiNotifier.notifyErrorOnce(ex.getMessage());
            throw new TemplateCreateException("Error on create menu template: " + path, ex);
        }
    }
}

