/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.menu;

import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.Pane;
import plfx.controller.lang.LangController;
import plfx.controller.page.ButtonPageController;
import plfx.controller.page.PageController;
import plfx.controller.page.PanePageController;
import plfx.element.FxInitException;
import plfx.element.SButton;
import plfx.screen.BaseFxScreenTemplate;
import plfx.screen.menu.MenuTemplate;
import plfx.screen.menu.MenuTemplateController;
import plfx.screen.menu.MenuTemplateListener;
import plfx.util.Locator;

public abstract class BaseMenuTemplate
extends BaseFxScreenTemplate
implements MenuTemplate {
    protected MenuTemplateListener listener;
    @FXML
    protected MenuTemplateController headerController;
    @FXML
    protected MenuTemplateController footerController;
    @FXML
    protected PageController pageController;
    @FXML
    protected LangController langController;
    private Pane groupLogo;

    public BaseMenuTemplate(String screenId) {
        super(screenId, "skin");
    }

    @Override
    public void init() throws FxInitException {
        super.init();
        this.getNextLangButton().setListener(() -> {
            if (this.listener != null) {
                this.listener.onNextLang();
            }
        });
        this.getLangButtons().stream().forEach(b -> this.setLangButtonListener((SButton)b));
        this.getSelectLangButton().setListener(() -> {
            if (this.listener != null) {
                this.listener.onSelectLang();
            }
        });
        this.groupLogo = this.searchPane("groupLogo", false);
        if (this.pageController == null) {
            if (this.headerController != null && this.headerController.getPageController() != null) {
                this.pageController = this.headerController.getPageController();
            } else if (this.footerController != null && this.footerController.getPageController() != null) {
                this.pageController = this.footerController.getPageController();
            } else {
                Node pn = this.rootPane.lookup("#browsePrevButton");
                Node nn = this.rootPane.lookup("#browseNextButton");
                if (pn != null && nn != null) {
                    if (pn instanceof Button && nn instanceof Button) {
                        this.pageController = new ButtonPageController((Button)nn, (Button)pn);
                    } else if (pn instanceof Pane && nn instanceof Pane) {
                        this.pageController = new PanePageController((Pane)nn, (Pane)pn);
                    }
                }
            }
        }
        if (this.langController == null) {
            if (this.headerController != null && this.headerController.getLangController() != null) {
                this.langController = this.headerController.getLangController();
            } else if (this.footerController != null && this.footerController.getLangController() != null) {
                this.langController = this.footerController.getLangController();
            }
        }
    }

    @Override
    public PageController getPageController() {
        return this.pageController;
    }

    @Override
    public LangController getLangController() {
        return this.langController;
    }

    @Override
    public void setListener(MenuTemplateListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listener = listener;
        if (this.headerController != null) {
            this.headerController.setListener(listener);
        }
        if (this.footerController != null) {
            this.footerController.setListener(listener);
        }
        if (this.langController != null) {
            this.langController.setListener(listener);
        }
        this.getActions().forEach((a, b) -> b.setListener(() -> listener.onAction((String)a)));
    }

    @FXML
    protected void onPaymentState() {
        if (this.listener != null) {
            this.listener.onPaymentState();
        }
    }

    @FXML
    protected void onSearchService() {
        if (this.listener != null) {
            this.listener.onSearchService();
        }
    }

    @FXML
    protected void onCheckCopy() {
        if (this.listener != null) {
            this.listener.onCheckCopy();
        }
    }

    @FXML
    protected void onHelp() {
        if (this.listener != null) {
            this.listener.onHelp();
        }
    }

    @FXML
    protected void onOffer(ActionEvent event) {
        if (this.listener != null) {
            Node source = (Node)event.getSource();
            Object obj = source.getProperties().get((Object)"file");
            if (obj != null && obj instanceof String) {
                this.listener.onOffer((String)obj);
            } else {
                this.listener.onOffer(null);
            }
        }
    }

    @FXML
    protected void onExit() {
        if (this.listener != null) {
            this.listener.onExit();
        }
    }

    @FXML
    protected void onBack() {
        if (this.listener != null) {
            this.listener.onBack();
        }
    }

    private void setLangButtonListener(SButton b) {
        if (b != null) {
            b.setListener(() -> {
                String lang;
                Object obj;
                if (this.listener != null && (obj = b.getNode().getProperties().get((Object)"lang")) != null && obj instanceof String && (lang = (String)obj).matches("[a-z]{2}")) {
                    this.listener.onSelectLang(lang);
                }
            });
        }
    }

    @Override
    public void setGroupLogo(String image) {
        if (this.groupLogo != null) {
            this.groupLogo.setStyle("");
            if (image != null && !image.isEmpty()) {
                this.groupLogo.setStyle("-fx-background-image: url(\"" + Locator.getPath("/gui/skin/{name}/img/" + image) + "\");");
            }
        }
    }

    public String toString() {
        return "BaseMenuTemplate{}";
    }
}

