/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.lang;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Properties;
import plfx.GuiNotifier;
import plfx.element.FxInitException;
import plfx.screen.ScreenCreateException;
import plfx.screen.lang.DefaultSelectLangScreen;
import plfx.screen.lang.DefaultSelectLangTemplate;
import plfx.screen.lang.SelectLangScreen;
import plfx.screen.lang.SelectLangTemplate;
import plfx.util.LoadTemplateException;
import plfx.util.Locator;
import plfx.util.ResourceLoader;

public class SelectLangScreenFactory {
    private SelectLangScreenFactory() {
    }

    public static SelectLangScreen createSelectLangScreen() throws ScreenCreateException {
        try {
            SelectLangScreen screen;
            Properties prop = Locator.readQuietly("/gui/skin/{name}//screen/lang/descriptor.properties", false);
            SelectLangTemplate template = null;
            String controller = prop.getProperty("controller", "");
            if (!controller.isEmpty()) {
                try {
                    template = (SelectLangTemplate)Class.forName(controller).newInstance();
                }
                catch (Throwable throwable) {
                    GuiNotifier.notifyError(throwable);
                    template = new DefaultSelectLangTemplate();
                }
            } else {
                template = new DefaultSelectLangTemplate();
            }
            ResourceLoader.load(Locator.getUrl("/gui/skin/{name}//screen/lang/template.fxml"), template);
            URL url = Locator.getUrl("/gui/skin/{name}/css/menu.css");
            if (url != null) {
                template.addUserStylesheet(url.toExternalForm());
            }
            template.init();
            String screenName = prop.getProperty("screen", "");
            if (!screenName.isEmpty()) {
                try {
                    Constructor<?> c = Class.forName(screenName).getConstructor(SelectLangTemplate.class);
                    screen = (SelectLangScreen)c.newInstance(template);
                }
                catch (Throwable throwable) {
                    GuiNotifier.notifyError(throwable);
                    screen = new DefaultSelectLangScreen(template);
                }
            } else {
                screen = new DefaultSelectLangScreen(template);
            }
            return screen;
        }
        catch (FxInitException | LoadTemplateException ex) {
            GuiNotifier.notifyError(ex);
            throw new ScreenCreateException("Erron on create selectlang temlate", ex);
        }
    }
}

