/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.lang;

import java.util.List;
import java.util.Locale;
import java.util.stream.IntStream;
import javafx.collections.ObservableList;
import plfx.controller.lang.Lang;
import plfx.element.ButtonListener;
import plfx.element.SButton;
import plfx.screen.FxScreenTemplate;
import plfx.screen.lang.SelectLangListener;
import plfx.screen.lang.SelectLangScreen;
import plfx.screen.lang.SelectLangTemplate;

public class DefaultSelectLangScreen
implements SelectLangScreen {
    private SelectLangTemplate template;
    private SelectLangListener listener;
    protected Locale currentLocale;
    private ObservableList<Lang> langs;

    public DefaultSelectLangScreen(SelectLangTemplate template) {
        if (template == null) {
            throw new NullPointerException("Template is not set");
        }
        this.template = template;
        template.getBackButton().setListener(new BackListener());
    }

    @Override
    public void init() {
        List<SButton> Buttons = this.template.getLangButtons();
        IntStream.range(0, Buttons.size()).forEach(i -> {
            SButton btn = (SButton)Buttons.get(i);
            btn.setVisible(false);
        });
        if (this.langs != null && !this.langs.isEmpty()) {
            if (this.langs.size() < Buttons.size()) {
                IntStream.range(0, this.langs.size()).forEach(i -> this.refreshButton((SButton)Buttons.get(i), (Lang)this.langs.get(i)));
            } else {
                IntStream.range(0, Buttons.size()).forEach(i -> this.refreshButton((SButton)Buttons.get(i), (Lang)this.langs.get(i)));
            }
        }
    }

    @Override
    public FxScreenTemplate getTemplate() {
        return this.template;
    }

    @Override
    public void setCurrentLocale(Locale locale) {
        this.currentLocale = locale;
    }

    @Override
    public void setListener(SelectLangListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener is not set");
        }
        this.listener = listener;
    }

    @Override
    public void setLocales(ObservableList<Lang> langs) {
        this.langs = langs;
    }

    private void refreshButton(SButton sButton, Lang lang) {
        sButton.setText(lang.getDisplayName());
        sButton.setListener(new SelectListener(lang.getCode()));
        sButton.setVisible(true);
    }

    private class SelectListener
    implements ButtonListener {
        private final String lang;

        public SelectListener(String lang) {
            this.lang = lang;
        }

        @Override
        public void onAction() {
            if (DefaultSelectLangScreen.this.listener != null) {
                DefaultSelectLangScreen.this.listener.onSelectLang(this.lang);
                DefaultSelectLangScreen.this.listener.onBack();
            }
        }
    }

    private class BackListener
    implements ButtonListener {
        private BackListener() {
        }

        @Override
        public void onAction() {
            if (DefaultSelectLangScreen.this.listener != null) {
                DefaultSelectLangScreen.this.listener.onBack();
            }
        }
    }
}

