/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.keeper.input.popup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import plfx.Options;
import plfx.element.UpDownLable;
import plfx.input.calendar.CalendarListener;
import plfx.input.keyboard.KeyboardAdapter;
import plfx.input.keyboard.KeyboardListener;
import plfx.input.keyboard.letter.Layout;
import plfx.input.selector.SelectorListener;
import plfx.model.textfield.InputFieldModel;
import plfx.screen.CommonScreen;
import plfx.screen.FxScreenTemplate;
import plfx.screen.ScreenInit;
import plfx.screen.ScreenListener;
import plfx.screen.input.group.CommonActionNotifier;
import plfx.screen.input.group.InputComponent;
import plfx.screen.input.group.InputComponentListener;
import plfx.screen.input.group.NumericInputComponent;
import plfx.screen.input.group.TextInputComponent;
import plfx.screen.keeper.input.popup.AutoComlpletePopupInputComponent;
import plfx.screen.keeper.input.popup.PopupAutoCompleteElement;
import plfx.screen.keeper.input.popup.PopupDatelElement;
import plfx.screen.keeper.input.popup.PopupDigitalElement;
import plfx.screen.keeper.input.popup.PopupLetterElement;
import plfx.screen.keeper.input.popup.PopupSelectorElement;
import plfx.screen.keeper.input.popup.PopupTemplate;
import plfx.screen.pay.ButtonActionListener;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.FieldType;
import ru.softlogic.input.model.field.IdentityField;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.autocomplete.AutoCompleteField;
import ru.softlogic.input.model.field.date.Calendar;
import ru.softlogic.input.model.field.date.DateField;
import ru.softlogic.input.model.field.numeric.NumericField;
import ru.softlogic.input.model.field.selector.SelectorField;
import ru.softlogic.input.model.field.selector.SelectorItem;
import ru.softlogic.input.model.field.text.Keyboard;
import ru.softlogic.input.model.field.text.KeyboardType;
import ru.softlogic.input.model.field.text.TextField;
import ru.softlogic.input.model.screen.Event;
import ru.softlogic.input.model.screen.description.ScreenDescription;

class PopupScreen
implements CommonScreen {
    private final PopupTemplate tpl;
    private final Optional<PopupLetterElement> tplLetter;
    private final Optional<PopupDigitalElement> tplDigital;
    private final Optional<PopupDigitalElement> tplDigitalDecimal;
    private final Optional<PopupDatelElement> tplDate;
    private final Optional<PopupAutoCompleteElement> tplAC;
    private final Optional<PopupSelectorElement> tplSelector;
    private InputComponent component;
    private IdentityField field;
    private LocalKeyboardListener keyboardListener;
    private CommonActionNotifier notifier;
    private String type;

    public PopupScreen(PopupTemplate tpl, Map<String, Layout> layouts) {
        this.tpl = Objects.requireNonNull(tpl, "PopupTemplate");
        this.keyboardListener = new LocalKeyboardListener();
        this.notifier = new CommonActionNotifier(this);
        tpl.getActions().forEach((a, b) -> b.setListener(() -> this.notifier.notify((String)a)));
        this.tplLetter = Optional.ofNullable(tpl.getPopupLetterTemplate());
        this.tplLetter.ifPresent(t -> {
            t.getLetterKeyboard().setKeyboardListener(this.keyboardListener);
            t.getLetterKeyboard().setLayouts(layouts);
            t.getBackButton().setListener(new ButtonActionListener("prev", this.notifier));
            t.getNextButton().setListener(new ButtonActionListener("next", this.notifier));
            t.getActions().forEach((a, b) -> b.setListener(() -> this.notifier.notify((String)a)));
            t.setVisible(false);
        });
        this.tplDigital = Optional.ofNullable(tpl.getPopupDigitalElement());
        this.tplDigital.ifPresent(t -> {
            t.getDigitalrKeyboard().setKeyboardListener(this.keyboardListener);
            t.getBackButton().setListener(new ButtonActionListener("prev", this.notifier));
            t.getNextButton().setListener(new ButtonActionListener("next", this.notifier));
            t.getActions().forEach((a, b) -> b.setListener(() -> this.notifier.notify((String)a)));
            t.setVisible(false);
        });
        this.tplDigitalDecimal = Optional.ofNullable(tpl.getPopupDigitalDecimalElement());
        this.tplDigitalDecimal.ifPresent(t -> {
            t.getDigitalrKeyboard().setKeyboardListener(this.keyboardListener);
            t.getBackButton().setListener(new ButtonActionListener("prev", this.notifier));
            t.getNextButton().setListener(new ButtonActionListener("next", this.notifier));
            t.getActions().forEach((a, b) -> b.setListener(() -> this.notifier.notify((String)a)));
            t.setVisible(false);
        });
        this.tplDate = Optional.ofNullable(tpl.getPopupDatelElement());
        this.tplDate.ifPresent(t -> {
            t.getBackButton().setListener(new ButtonActionListener("prev", this.notifier));
            t.getNextButton().setListener(new ButtonActionListener("next", this.notifier));
            t.getActions().forEach((a, b) -> b.setListener(() -> this.notifier.notify((String)a)));
            t.setVisible(false);
        });
        this.tplAC = Optional.ofNullable(tpl.getPopupAutoCompleteElement());
        this.tplAC.ifPresent(t -> {
            t.getBackButton().setListener(new ButtonActionListener("prev", this.notifier));
            t.getNextButton().setListener(new ButtonActionListener("next", this.notifier));
            t.getLetterKeyboard().setKeyboardListener(this.keyboardListener);
            t.getLetterKeyboard().setLayouts(layouts);
            t.getActions().forEach((a, b) -> b.setListener(() -> this.notifier.notify((String)a)));
            t.setVisible(false);
        });
        this.tplSelector = Optional.ofNullable(tpl.getPopupSelectorElement());
        this.tplSelector.ifPresent(t -> {
            t.getBackButton().setListener(new ButtonActionListener("prev", this.notifier));
            t.getNextButton().setListener(new ButtonActionListener("next", this.notifier));
            t.getActions().forEach((a, b) -> b.setListener(() -> this.notifier.notify((String)a)));
            t.setVisible(false);
        });
    }

    @Override
    public void init(ScreenDescription sd, ScreenInit si) throws InitException {
        if (sd.getSequence() == null || sd.getSequence().getFields() == null || sd.getSequence().getFields().isEmpty()) {
            throw new InitException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u044b \u043f\u043e\u043b\u044f");
        }
        Map d = si.getModelEnvironment().getData();
        this.field = (IdentityField)sd.getSequence().initFields(si.getModelEnvironment()).get(0);
        this.type = null;
        this.tplLetter.ifPresent(t -> t.setVisible(false));
        this.tplDigital.ifPresent(t -> t.setVisible(false));
        this.tplDigitalDecimal.ifPresent(t -> t.setVisible(false));
        this.tplDate.ifPresent(t -> t.setVisible(false));
        this.tplAC.ifPresent(t -> t.setVisible(false));
        this.tplSelector.ifPresent(t -> t.setVisible(false));
        if (this.field.getType() == FieldType.Letter) {
            TextField tf = (TextField)this.field;
            Label label = new Label();
            this.component = new TextInputComponent(label, tf, d.get(tf.getId()), new KeyBoardComponentListener(), 0);
            if (KeyboardType.Digital == tf.getKeyboard().getType()) {
                this.type = "digital";
                this.tplDigital.get().getTitledArea().setControl((Control)label);
                this.tplDigital.get().setVisible(true);
            } else {
                this.type = "letter";
                this.tplLetter.get().getTitledArea().setControl((Control)label);
                this.tplLetter.get().setVisible(true);
            }
        } else if (this.field.getType() == FieldType.Numeric) {
            NumericField nf = (NumericField)this.field;
            UpDownLable udl = new UpDownLable(Math.abs(nf.getUpdown()) > 0.01);
            this.component = new NumericInputComponent(udl, nf, d.get(nf.getId()), new KeyBoardComponentListener(), 0);
            if (nf.getKeyboard().getExtraCharacter() == null) {
                if (KeyboardType.Digital == nf.getKeyboard().getType()) {
                    this.type = "digital";
                    this.tplDigital.get().getTitledArea().setControl(udl);
                    this.tplDigital.get().setVisible(true);
                } else {
                    this.type = "letter";
                    this.tplLetter.get().getTitledArea().setControl(udl);
                    this.tplLetter.get().setVisible(true);
                }
            } else {
                this.type = "digitalDecimal";
                this.tplDigitalDecimal.ifPresent(t -> t.getTitledArea().setControl(udl));
                this.tplDigitalDecimal.ifPresent(t -> t.setVisible(true));
            }
        } else if (this.field.getType() == FieldType.Date) {
            DateField df = (DateField)this.field;
            DateComponent dc = new DateComponent(df);
            this.component = dc;
            this.tplDate.get().getGuiCalendar().init(new Calendar(df.getFrom(), df.getTo(), df.getValue()));
            this.tplDate.get().getGuiCalendar().setCalendarListener(dc);
            this.tplDate.get().setVisible(true);
            this.type = "date";
        } else if (this.field.getType() == FieldType.Selector) {
            SelectorField sf = (SelectorField)this.field;
            SelectorComponent sc = new SelectorComponent(sf.getItems());
            this.component = sc;
            ArrayList<String> l = new ArrayList<String>(sf.getItems().size());
            for (SelectorItem sit : sf.getItems()) {
                l.add(sit.getTitle());
            }
            this.tplSelector.get().getGuiSelector().init(l);
            this.tplSelector.get().getGuiSelector().setSelectorListener(sc);
            this.tplSelector.get().setVisible(true);
            this.type = "selector";
        } else if (this.field.getType() == FieldType.AutoComplete) {
            AutoCompleteField acf = (AutoCompleteField)this.field;
            Label label = new Label();
            this.component = new AutoComlpletePopupInputComponent(label, acf, d.get(this.field.getId()), new KeyBoardComponentListener(), this.tplAC.get().getGuiSelector(), 0);
            this.tplAC.get().getTitledArea().setControl((Control)label);
            this.tplAC.get().setVisible(true);
            this.type = "ac";
        }
        this.notifier.init();
        this.notifier.setComponents(Arrays.asList(this.component));
        this.component.getFocus();
        this.processNext(this.type);
    }

    @Override
    public void onEvent(Event event) {
        Options.GUI.info((Object)("Event " + event + " in PopupScreen is ignored"));
    }

    void processNext(String type) {
        if (null != type) {
            switch (type) {
                case "digital": {
                    this.tplDigital.get().getNextButton().setDisable(this.component != null ? !this.component.isValid() : true);
                    break;
                }
                case "digitalDecimal": {
                    this.tplDigitalDecimal.ifPresent(t -> t.getNextButton().setDisable(this.component != null ? !this.component.isValid() : true));
                    break;
                }
                case "letter": {
                    this.tplLetter.get().getNextButton().setDisable(this.component != null ? !this.component.isValid() : true);
                    break;
                }
                case "date": {
                    this.tplDate.get().getNextButton().setDisable(this.component != null ? !this.component.isValid() : true);
                    break;
                }
                case "selector": {
                    this.tplSelector.get().getNextButton().setDisable(this.component != null ? !this.component.isValid() : true);
                    break;
                }
                case "ac": {
                    this.tplAC.get().getNextButton().setDisable(this.component != null ? !this.component.isValid() : true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown type");
                }
            }
        }
    }

    @Override
    public void setListener(ScreenListener listener) {
        this.notifier.setListener(listener);
    }

    @Override
    public FxScreenTemplate getTemplate() {
        return this.tpl;
    }

    @Override
    public KeyboardListener getKeyboardListener() {
        return null;
    }

    private class LocalKeyboardListener
    extends KeyboardAdapter {
        private InputFieldModel model;
        private InputComponent component;

        private LocalKeyboardListener() {
        }

        @Override
        public void setModel(InputFieldModel model) {
            this.model = model;
        }

        public void setComponent(InputComponent component) {
            this.component = component;
        }

        @Override
        public void onKeyPress(char key) {
            if (this.model != null) {
                this.model.add(key);
            }
        }

        @Override
        public void onClear() {
            if (this.model != null) {
                this.model.clear();
            }
        }

        @Override
        public void onClearLast() {
            if (this.model != null) {
                this.model.clearLast();
            }
        }

        @Override
        public void onEnter() {
            if (this.component.isValid()) {
                PopupScreen.this.notifier.notify("next");
            }
        }
    }

    private class SelectorComponent
    implements SelectorListener,
    InputComponent {
        private final List<SelectorItem> list;
        private SelectorItem selected;

        public SelectorComponent(List<SelectorItem> list) {
            this.list = list;
        }

        @Override
        public void onSelect(int index) {
            this.selected = this.list.get(index);
            PopupScreen.this.processNext("selector");
        }

        @Override
        public boolean isValid() {
            return this.selected != null;
        }

        @Override
        public void putData(Map<String, Object> data) {
            if (this.selected != null) {
                Data d;
                data.put(PopupScreen.this.field.getId(), new InputElement(PopupScreen.this.field.getId(), PopupScreen.this.field.getTitle(), PopupScreen.this.field.getTitleId(), this.selected.getValue(), this.selected.getTitle(), PopupScreen.this.field.getFlags()));
                if (this.selected.getData() != null && (d = this.selected.getData()) != null && d.getElements() != null) {
                    for (InputElement el : d.getElements()) {
                        data.put(el.getKey(), el);
                    }
                    if (d.getNestedData() != null) {
                        data.put(d.getNestedData().getId(), d.getNestedData().getData());
                    }
                    if (d.getSum() != null) {
                        data.put("#sum", d.getSum());
                    }
                }
            }
        }

        @Override
        public void getFocus() {
        }

        @Override
        public void onLostFocus() {
        }

        @Override
        public void setWarning(boolean warning) {
        }

        @Override
        public int getIndex() {
            return 0;
        }

        @Override
        public void update(Map<String, Object> data) {
        }

        @Override
        public Control getControl() {
            return null;
        }
    }

    private class DateComponent
    implements CalendarListener,
    InputComponent {
        private Date select;
        private final DateField dateField;

        public DateComponent(DateField dateField) {
            this.dateField = dateField;
            this.select = dateField.getValue();
            PopupScreen.this.processNext("date");
        }

        @Override
        public void onSelect(Date date) {
            if (date != null) {
                this.select = date;
                PopupScreen.this.processNext("date");
            }
        }

        @Override
        public boolean isValid() {
            return this.select != null;
        }

        @Override
        public void putData(Map<String, Object> data) {
            if (this.select != null) {
                data.put(this.dateField.getId(), new InputElement(this.dateField.getId(), this.dateField.getTitle(), this.dateField.getTitleId(), this.dateField.getFormater().format(this.select), this.dateField.getFormaterTitle().format(this.select), this.dateField.getFlags()));
            }
        }

        @Override
        public void getFocus() {
        }

        @Override
        public void onLostFocus() {
        }

        @Override
        public void setWarning(boolean warning) {
        }

        @Override
        public int getIndex() {
            return 0;
        }

        @Override
        public void update(Map<String, Object> data) {
        }

        @Override
        public Control getControl() {
            return null;
        }
    }

    private class KeyBoardComponentListener
    implements InputComponentListener {
        private KeyBoardComponentListener() {
        }

        @Override
        public void onSelect(InputComponent component, InputFieldModel model, Object init) {
            Keyboard keyboard = (Keyboard)init;
            PopupScreen.this.keyboardListener.setComponent(component);
            PopupScreen.this.keyboardListener.setModel(model);
            if (null != PopupScreen.this.type) {
                switch (PopupScreen.this.type) {
                    case "digital": {
                        ((PopupDigitalElement)PopupScreen.this.tplDigital.get()).getDigitalrKeyboard().init(keyboard);
                        break;
                    }
                    case "digitalDecimal": {
                        PopupScreen.this.tplDigitalDecimal.ifPresent(t -> t.getDigitalrKeyboard().init(keyboard));
                        break;
                    }
                    case "ac": {
                        ((PopupAutoCompleteElement)PopupScreen.this.tplAC.get()).getLetterKeyboard().init(keyboard);
                        break;
                    }
                    default: {
                        ((PopupLetterElement)PopupScreen.this.tplLetter.get()).getLetterKeyboard().init(keyboard);
                    }
                }
            }
        }

        @Override
        public void onChange() {
            PopupScreen.this.processNext(PopupScreen.this.type);
        }

        @Override
        public void notifyUpdate() {
        }
    }
}

