/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.keeper.input.popup;

import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Properties;
import plfx.GuiNotifier;
import plfx.element.FxInitException;
import plfx.input.keyboard.letter.Layout;
import plfx.input.keyboard.letter.LayoutLoader;
import plfx.screen.CommonScreen;
import plfx.screen.CommonScreenFactory;
import plfx.screen.ScreenCreateException;
import plfx.screen.keeper.input.popup.DefaultPopupTemplate;
import plfx.screen.keeper.input.popup.PopupScreen;
import plfx.screen.keeper.input.popup.PopupTemplate;
import plfx.util.LoadTemplateException;
import plfx.util.Locator;
import plfx.util.ResourceLoader;

public class DefaultPopupFactory
implements CommonScreenFactory {
    @Override
    public CommonScreen create(String path, Properties prop) throws ScreenCreateException {
        try {
            CommonScreen screen;
            PopupTemplate template;
            Map<String, Layout> layouts;
            try {
                layouts = LayoutLoader.readLayouts("/screen/pay/" + path + "/layout.properties", prop);
            }
            catch (FxInitException ex) {
                layouts = LayoutLoader.readLayouts("/layout/default.properties", prop);
            }
            String controller = prop.getProperty("controller", "");
            if (!controller.isEmpty()) {
                try {
                    Constructor<?> c = Class.forName(controller).getConstructor(String.class, String.class);
                    template = (PopupTemplate)c.newInstance("screen.pay." + path, path.startsWith("@") ? "sys" : "skin");
                }
                catch (Throwable throwable) {
                    template = new DefaultPopupTemplate("screen.pay." + path, path.startsWith("@") ? "sys" : "skin");
                    GuiNotifier.notifyError(throwable);
                }
            } else {
                template = new DefaultPopupTemplate("screen.pay." + path, path.startsWith("@") ? "sys" : "skin");
            }
            ResourceLoader.load(Locator.getUrl("/gui/skin/{name}//screen/pay/" + path + "/template.fxml"), template);
            template.init();
            String screenName = prop.getProperty("screen", "");
            if (!screenName.isEmpty()) {
                try {
                    Constructor<?> c = Class.forName(screenName).getConstructor(PopupTemplate.class, Map.class);
                    screen = (CommonScreen)c.newInstance(template, layouts);
                }
                catch (Throwable throwable) {
                    screen = new PopupScreen(template, layouts);
                    GuiNotifier.notifyError(throwable);
                }
            } else {
                screen = new PopupScreen(template, layouts);
            }
            return screen;
        }
        catch (FxInitException | LoadTemplateException ex) {
            GuiNotifier.notifyError(ex);
            throw new ScreenCreateException("Erron on create group screen: " + path, ex);
        }
    }
}

