/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.keeper.input.popup;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.OverrunStyle;
import javafx.scene.input.MouseEvent;
import plfx.input.selector.GuiSelector;
import plfx.model.textfield.FieldListener;
import plfx.model.textfield.InputFieldModel;
import plfx.screen.input.group.InputComponent;
import plfx.screen.input.group.InputComponentListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.autocomplete.AutoCompleteField;

public class AutoComlpletePopupInputComponent
implements InputComponent,
EventHandler<MouseEvent> {
    protected AutoCompleteField field;
    protected Label component;
    protected InputFieldModel model;
    protected InputComponentListener listener;
    protected boolean selected;
    protected boolean warning;
    protected int index;
    protected InputElement complete;
    protected boolean completed;
    private final GuiSelector guiSelector;

    public AutoComlpletePopupInputComponent(Label component, AutoCompleteField field, Object oValue, InputComponentListener listener, GuiSelector guiSelector, int index) {
        this.field = field;
        this.listener = listener;
        this.component = component;
        this.index = index;
        component.getStyleClass().add((Object)"element-label");
        component.getStyleClass().add((Object)"label");
        component.setOnMousePressed((EventHandler)this);
        this.guiSelector = guiSelector;
        this.model = new AutoCompleteModel();
        this.model.addListener(new FieldListener(){

            @Override
            public void onChange(String value) {
                if (AutoComlpletePopupInputComponent.this.completed) {
                    AutoComlpletePopupInputComponent.this.component.setText(value);
                    AutoComlpletePopupInputComponent.this.completed = false;
                } else {
                    AutoComlpletePopupInputComponent.this.complete = null;
                    AutoComlpletePopupInputComponent.this.component.setText(value);
                    AutoComlpletePopupInputComponent.this.listener.onChange();
                }
            }

            @Override
            public void onEnter(String value) {
            }
        });
        this.model.setValue("");
        if (oValue instanceof InputElement) {
            InputElement ie;
            this.complete = ie = (InputElement)oValue;
            this.completed = false;
            component.setText(ie.getValueTitle());
        } else {
            InputElement def = field.getDataStore().getDefaultElement();
            if (def != null) {
                this.complete = def;
                this.completed = false;
                component.setText(def.getValueTitle());
            }
        }
        new AutoCompleteListener(component);
        this.updateStyle();
    }

    @Override
    public boolean isValid() {
        return this.complete != null || this.field.isOptional();
    }

    @Override
    public void putData(Map<String, Object> data) {
        if (this.complete != null) {
            this.complete.setKey(this.field.getId());
            this.complete.setKeyTitle(this.field.getTitle());
            this.complete.setKeyTitleId(this.field.getTitleId());
            this.complete.setFlags(this.field.getFlags());
            data.put(this.field.getId(), this.complete);
        }
    }

    public String toString() {
        return "AutoCompleteInputComponent{field=" + this.field + '}';
    }

    @Override
    public void getFocus() {
        this.selected = true;
        this.component.setTextOverrun(OverrunStyle.LEADING_ELLIPSIS);
        this.listener.onSelect(this, this.model, this.field.getKeyboard());
        this.updateStyle();
    }

    @Override
    public void onLostFocus() {
        this.selected = false;
        this.component.setTextOverrun(OverrunStyle.ELLIPSIS);
        this.updateStyle();
    }

    @Override
    public void setWarning(boolean warning) {
        this.warning = warning;
        this.updateStyle();
    }

    public void handle(MouseEvent t) {
        this.getFocus();
    }

    private void updateStyle() {
        this.component.getStyleClass().remove((Object)"element-label-selected");
        this.component.getStyleClass().remove((Object)"element-label-error");
        if (this.selected) {
            this.component.getStyleClass().add((Object)"element-label-selected");
        }
        if (this.warning) {
            this.component.getStyleClass().add((Object)"element-label-error");
        }
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void update(Map<String, Object> data) {
        Object obj = data.get(this.field.getId());
        if (obj != null && obj instanceof InputElement) {
            InputElement ie = (InputElement)obj;
            this.model.setValue(ie.getOriginalValue());
            this.updateStyle();
        }
    }

    @Override
    public Control getControl() {
        return this.component;
    }

    private static class AutoCompleteModel
    implements InputFieldModel {
        private String value;
        private final Set<FieldListener> listeners = new LinkedHashSet<FieldListener>();

        @Override
        public void add(char ch) {
            this._add(ch, true);
        }

        @Override
        public void clear() {
            this.value = "";
            this.notifyListeners();
        }

        @Override
        public void clearLast() {
            this.value = this.value.length() > 0 ? this.value.substring(0, this.value.length() - 1) : "";
            this.notifyListeners();
        }

        @Override
        public void setValue(String value) {
            this.value = "";
            if (value != null && !value.isEmpty()) {
                for (char ch : value.toCharArray()) {
                    this._add(ch, false);
                }
                this.notifyListeners();
            }
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String getClearValue() {
            return this.value;
        }

        @Override
        public void addListener(FieldListener listener) {
            if (listener != null) {
                this.listeners.add(listener);
            }
        }

        private void notifyListeners() {
            for (FieldListener fl : this.listeners) {
                fl.onChange(this.getValue());
            }
        }

        private void _add(char ch, boolean doNotify) {
            this.value = this.value + ch;
            if (doNotify) {
                this.notifyListeners();
            }
        }

        @Override
        public void enter() {
            this.listeners.forEach(fl -> fl.onEnter(this.getValue()));
        }
    }

    private class AutoCompleteListener
    implements ChangeListener<String> {
        public AutoCompleteListener(Label label) {
            label.textProperty().addListener((ChangeListener)this);
            AutoComlpletePopupInputComponent.this.guiSelector.init(Collections.emptyList());
        }

        public void changed(ObservableValue<? extends String> ov, String t, String value) {
            if (value != null && !value.isEmpty() && value.length() >= AutoComlpletePopupInputComponent.this.field.getMinChars()) {
                List result = AutoComlpletePopupInputComponent.this.field.getDataStore().getElements(value, AutoComlpletePopupInputComponent.this.field.getMaxItems());
                if (AutoComlpletePopupInputComponent.this.complete != null) {
                    result.remove(AutoComlpletePopupInputComponent.this.complete);
                }
                if (!result.isEmpty() && result.size() <= AutoComlpletePopupInputComponent.this.field.getMaxItems()) {
                    List<String> list = result.stream().map(InputElement::getValueTitle).collect(Collectors.toList());
                    AutoComlpletePopupInputComponent.this.guiSelector.setSelectorListener(i -> {
                        AutoComlpletePopupInputComponent.this.complete = (InputElement)result.get(i);
                        if (AutoComlpletePopupInputComponent.this.complete != null) {
                            AutoComlpletePopupInputComponent.this.completed = true;
                            AutoComlpletePopupInputComponent.this.model.setValue(AutoComlpletePopupInputComponent.this.complete.getValueTitle());
                            AutoComlpletePopupInputComponent.this.listener.onChange();
                            AutoComlpletePopupInputComponent.this.guiSelector.init(Collections.emptyList());
                        }
                    });
                    AutoComlpletePopupInputComponent.this.guiSelector.init(list);
                } else {
                    AutoComlpletePopupInputComponent.this.guiSelector.init(Collections.emptyList());
                }
            }
        }
    }
}

