/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.table;

import java.util.HashSet;
import plfx.input.keyboard.KeyboardListener;
import plfx.model.action.ActionNotifier;
import plfx.screen.BaseCommonScreen;
import plfx.screen.FxScreenTemplate;
import plfx.screen.ScreenInit;
import plfx.screen.ScreenListener;
import plfx.screen.input.table.TableActionListener;
import plfx.screen.input.table.TableActionNotifier;
import plfx.screen.input.table.TableTemplate;
import plfx.screen.input.table.TableTemplateListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.Field;
import ru.softlogic.input.model.field.FieldType;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.table.TableColumn;
import ru.softlogic.input.model.field.table.TableField;
import ru.softlogic.input.model.field.table.TableItem;
import ru.softlogic.input.model.screen.description.ScreenDescription;

public class TableScreen
extends BaseCommonScreen {
    private TableTemplate tpl;
    private TableActionNotifier notifier;

    public TableScreen(TableTemplate tpl) {
        if (tpl == null) {
            throw new NullPointerException("TableTemplate");
        }
        this.tpl = tpl;
        this.notifier = new TableActionNotifier(this);
        tpl.getBackButton().setListener(new TableActionListener("prev", this.notifier, null));
        tpl.getExitButton().setListener(new TableActionListener("exit", this.notifier, null));
        tpl.getActions().forEach((a, b) -> b.setListener(() -> this.notifier.notify((String)a)));
    }

    @Override
    protected void _init(ScreenDescription sd, ScreenInit si) throws InitException {
        TableItem selectedItem;
        if (sd.getSequence().getFields() == null || sd.getSequence().getFields().size() != 1) {
            throw new InitException("Screen must have one field");
        }
        this.tpl.initButtons(sd.getButtons());
        Field field = (Field)sd.getSequence().initFields(si.getModelEnvironment()).get(0);
        if (field.getType() != FieldType.Table) {
            throw new InitException("Field has wrong type");
        }
        TableField tf = (TableField)sd.getSequence().getFields().get(0);
        for (TableColumn tc : tf.getColumns()) {
            for (TableItem ti : tf.getTableItems()) {
                InputElement ie = (InputElement)ti.getElements().get(tc.getKey());
                if (ie != null) continue;
                throw new InitException("Input element for column <" + tc.getKey() + "> can not be null");
            }
        }
        this.tpl.setTable(tf.getColumns(), tf.getTableItems(), tf.isReadonly(), new LocalTemplateListener(), tf.getEmptyText());
        this.notifier.init();
        this.notifier.setField(tf);
        this.tpl.setServiceLogo(sd.getIcon(), sd.getStyleClass());
        if (this.tpl.getNavigation() != null) {
            this.tpl.getNavigation().init(sd.getNavigations(), this.notifier);
        }
        if ((selectedItem = this.getSelectedItem(tf, si)) != null) {
            this.tpl.selectItem(selectedItem);
        }
    }

    @Override
    public void setListener(ScreenListener listener) {
        this.notifier.setListener(listener);
    }

    @Override
    public KeyboardListener getKeyboardListener() {
        return null;
    }

    @Override
    public FxScreenTemplate getTemplate() {
        return this.tpl;
    }

    @Override
    protected ActionNotifier getActionNotifier() {
        return this.notifier;
    }

    private TableItem getSelectedItem(TableField tf, ScreenInit si) {
        for (TableItem ti : tf.getTableItems()) {
            HashSet<InputElement> ies = new HashSet<InputElement>();
            for (TableColumn tc : tf.getColumns()) {
                InputElement get;
                InputElement ie = (InputElement)ti.getElements().get(tc.getKey());
                if (ie == null || !ie.equals((Object)(get = (InputElement)si.getModelEnvironment().getData().get(ie.getKey())))) continue;
                ies.add(get);
            }
            if (ti.getElements().size() != ies.size()) continue;
            return ti;
        }
        return null;
    }

    private class LocalTemplateListener
    implements TableTemplateListener {
        private LocalTemplateListener() {
        }

        @Override
        public void onSelect(TableItem item) {
            TableScreen.this.notifier.setItem(item);
            TableScreen.this.notifier.notify("next");
        }
    }
}

