/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.table;

import java.util.LinkedHashMap;
import java.util.List;
import plfx.model.action.LockableActionNotifier;
import plfx.screen.Screen;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.input.model.field.table.TableField;
import ru.softlogic.input.model.field.table.TableItem;

public class TableActionNotifier
extends LockableActionNotifier {
    private TableField field;
    private TableItem item;

    public TableActionNotifier(Screen screen) {
        super("TableActionNotifier", screen);
    }

    public void setField(TableField field) {
        this.field = field;
    }

    public void setItem(TableItem item) {
        this.item = item;
    }

    @Override
    protected void _notify(String type) {
        if (this.listener != null) {
            LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
            if (this.item != null && this.field != null) {
                data.put(this.field.getId(), new InputElement(this.field.getId(), this.field.getTitle(), this.field.getTitleId(), this.item.getValue(), this.field.getFlags()));
                if (this.item.getData() != null) {
                    Data d = this.item.getData();
                    StoreHelper.mergeData(data, (List)d.getElements());
                    if (d.getNestedData() != null) {
                        data.put(d.getNestedData().getId(), d.getNestedData().getData());
                    }
                    if (d.getSum() != null) {
                        data.put("#sum", d.getSum());
                    }
                }
            }
            this.listener.onAction(type, data, this);
        }
    }

    @Override
    protected String getAdditionalLockInfo() {
        if (this.field == null) {
            return null;
        }
        return "fieldId: " + this.field.getId() + ", title: " + this.field;
    }
}

