/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.table;

import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.text.Text;
import plfx.element.FxInitException;
import plfx.msg.ScreenElement;
import plfx.msg.TableViewMessageTemplate;
import plfx.screen.input.table.BaseTableTemplate;
import plfx.screen.input.table.TableTemplateListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.table.TableItem;

public class DefaultTableTemplate
extends BaseTableTemplate {
    @FXML
    private TableView<TableItem> tableView;
    private TableTemplateListener listener;
    private List<ru.softlogic.input.model.field.table.TableColumn> columns;
    private List<TableItem> items;
    private Boolean readonly = false;
    protected static int SCROLLSIZE = 61;

    public DefaultTableTemplate(String screenId) {
        super(screenId);
    }

    @Override
    public void init() throws FxInitException {
        super.init();
        this.tableView.setEditable(false);
        this.tableView.setPlaceholder((Node)new Text(""));
        this.tableView.setColumnResizePolicy(p -> false);
        this.tableView.getSelectionModel().selectedItemProperty().addListener(o -> {
            if (this.tableView.getSelectionModel().getSelectedIndex() >= 0) {
                this.setButtonState(true);
            }
        });
        this.nextBtn.setListener(() -> {
            if (this.listener != null) {
                if (this.readonly.booleanValue()) {
                    this.listener.onSelect(this.items.get(0));
                } else {
                    this.listener.onSelect((TableItem)this.tableView.getSelectionModel().getSelectedItem());
                }
            }
        });
    }

    private void setButtonState(boolean active) {
        this.nextBtn.setDisable(!active);
    }

    @Override
    public void setTable(List<ru.softlogic.input.model.field.table.TableColumn> columns, List<TableItem> items, Boolean readonly, TableTemplateListener listener, String emptyText) {
        this.columns = columns;
        this.items = items;
        this.listener = listener;
        this.readonly = readonly;
        this.getDynamicElements().clear();
        this.tableView.setMouseTransparent(readonly.booleanValue());
        this.setButtonState(readonly);
        this.tableView.getColumns().clear();
        if (emptyText != null) {
            this.tableView.setPlaceholder((Node)new Text(emptyText));
        }
        ObservableList data = FXCollections.observableArrayList(items);
        LinkedList<TableColumn> cols = new LinkedList<TableColumn>();
        for (ru.softlogic.input.model.field.table.TableColumn tc : this.columns) {
            TableColumn col = new TableColumn();
            if (tc.getTitleid() != null) {
                this.getDynamicElements().add(new ScreenElement(new TableViewMessageTemplate(col, "$lu.get(\"" + tc.getTitleid() + "\")")));
            } else {
                col.setText(tc.getTitle());
            }
            String id = tc.getKey();
            col.prefWidthProperty().bind((ObservableValue)this.tableView.widthProperty().add(-SCROLLSIZE).multiply(tc.getWidth() / 100.0));
            col.setCellValueFactory(p -> {
                InputElement ie = (InputElement)((TableItem)p.getValue()).getElements().get(id);
                if (ie != null) {
                    if (ie.getValueTitle() != null) {
                        return new SimpleStringProperty(((InputElement)((TableItem)p.getValue()).getElements().get(id)).getValueTitle());
                    }
                    return new SimpleStringProperty(((InputElement)((TableItem)p.getValue()).getElements().get(id)).getValue());
                }
                return new SimpleStringProperty("");
            });
            cols.add(col);
        }
        this.tableView.getColumns().addAll(cols);
        this.tableView.setItems(data);
    }

    @Override
    public void selectItem(TableItem item) {
        int itemIndex = this.tableView.getItems().indexOf((Object)item);
        if (itemIndex >= 0) {
            this.tableView.getSelectionModel().clearAndSelect(itemIndex);
        }
    }
}

