/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.table;

import java.lang.reflect.Constructor;
import java.util.Properties;
import plfx.GuiNotifier;
import plfx.element.FxInitException;
import plfx.screen.CommonScreen;
import plfx.screen.CommonScreenFactory;
import plfx.screen.ScreenCreateException;
import plfx.screen.input.table.DefaultTableTemplate;
import plfx.screen.input.table.TableScreen;
import plfx.screen.input.table.TableTemplate;
import plfx.util.LoadTemplateException;
import plfx.util.Locator;
import plfx.util.ResourceLoader;

public class DefaultTableFactory
implements CommonScreenFactory {
    @Override
    public CommonScreen create(String path, Properties prop) throws ScreenCreateException {
        try {
            TableTemplate template = null;
            String controller = prop.getProperty("controller", "");
            if (!controller.isEmpty()) {
                try {
                    Constructor<?> c = Class.forName(controller).getConstructor(String.class);
                    template = (TableTemplate)c.newInstance("screen.pay." + path);
                }
                catch (Throwable throwable) {
                    GuiNotifier.notifyError(throwable);
                    template = new DefaultTableTemplate("screen.pay." + path);
                }
            } else {
                template = new DefaultTableTemplate("screen.pay." + path);
            }
            ResourceLoader.load(Locator.getUrl("/gui/skin/{name}//screen/pay/" + path + "/template.fxml"), template);
            template.init();
            CommonScreen screen = null;
            String screenName = prop.getProperty("screen", "");
            if (!screenName.isEmpty()) {
                try {
                    Constructor<?> c = Class.forName(screenName).getConstructor(TableTemplate.class);
                    screen = (CommonScreen)c.newInstance(template);
                }
                catch (Throwable throwable) {
                    GuiNotifier.notifyError(throwable);
                    screen = new TableScreen(template);
                }
            } else {
                screen = new TableScreen(template);
            }
            return screen;
        }
        catch (FxInitException | LoadTemplateException ex) {
            GuiNotifier.notifyError(ex);
            throw new ScreenCreateException("Erron on create info screen: " + path, ex);
        }
    }
}

