/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.site;

import java.util.LinkedHashMap;
import java.util.Objects;
import plfx.input.keyboard.KeyboardListener;
import plfx.model.action.ActionNotifier;
import plfx.screen.BaseCommonScreen;
import plfx.screen.FxScreenTemplate;
import plfx.screen.ScreenInit;
import plfx.screen.ScreenListener;
import plfx.screen.input.site.SiteActionNotifier;
import plfx.screen.input.site.SiteTemplate;
import plfx.screen.input.site.SiteTemplateListener;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.screen.description.LocalSiteScreenDescription;
import ru.softlogic.input.model.screen.description.ScreenDescription;

public class SiteScreen
extends BaseCommonScreen {
    private final SiteTemplate tpl;
    private final SiteActionNotifier notifier;

    public SiteScreen(SiteTemplate tpl) {
        this.tpl = Objects.requireNonNull(tpl, "SiteTemplate");
        this.notifier = new SiteActionNotifier(this);
        this.tpl.setSiteListener(new LocalSiteListener());
    }

    @Override
    protected void _init(ScreenDescription sd, ScreenInit si) throws InitException {
        if (!(sd instanceof LocalSiteScreenDescription)) {
            throw new InitException("Wrong ScreenDescription");
        }
        LocalSiteScreenDescription lssd = (LocalSiteScreenDescription)sd;
        this.tpl.load(lssd.getUrl());
        this.notifier.init();
    }

    @Override
    public void setListener(ScreenListener listener) {
        this.notifier.setListener(listener);
    }

    @Override
    public KeyboardListener getKeyboardListener() {
        return null;
    }

    @Override
    public FxScreenTemplate getTemplate() {
        return this.tpl;
    }

    @Override
    protected ActionNotifier getActionNotifier() {
        return this.notifier;
    }

    public class LocalSiteListener
    implements SiteTemplateListener {
        @Override
        public void toMain() {
            SiteScreen.this.notifier.setData(null);
            SiteScreen.this.notifier.notify("toMain");
        }

        @Override
        public void toPay(String data, int sumOperation) {
            LinkedHashMap<String, Object> d = new LinkedHashMap<String, Object>();
            d.put("data", data);
            d.put("sum", sumOperation);
            SiteScreen.this.notifier.setData(d);
            SiteScreen.this.notifier.notify("toPay");
        }

        @Override
        public void toService(int id) {
            LinkedHashMap<String, Object> d = new LinkedHashMap<String, Object>();
            d.put("id", id);
            SiteScreen.this.notifier.setData(d);
            SiteScreen.this.notifier.notify("toService");
        }

        @Override
        public void toPrinter(String template, String data) {
            LinkedHashMap<String, Object> d = new LinkedHashMap<String, Object>();
            d.put("template", template);
            d.put("data", data);
            SiteScreen.this.notifier.setData(d);
            SiteScreen.this.notifier.notify("toPrinter");
        }

        @Override
        public void toBack() {
            SiteScreen.this.notifier.setData(null);
            SiteScreen.this.notifier.notify("toBack");
        }
    }
}

