/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.site;

import java.lang.reflect.Constructor;
import java.util.Properties;
import plfx.GuiNotifier;
import plfx.element.FxInitException;
import plfx.screen.CommonScreen;
import plfx.screen.CommonScreenFactory;
import plfx.screen.ScreenCreateException;
import plfx.screen.input.site.DefaultSiteTemplate;
import plfx.screen.input.site.SiteScreen;
import plfx.screen.input.site.SiteTemplate;
import plfx.util.LoadTemplateException;
import plfx.util.Locator;
import plfx.util.ResourceLoader;

public class DefaultSiteFactory
implements CommonScreenFactory {
    @Override
    public CommonScreen create(String path, Properties prop) throws ScreenCreateException {
        try {
            SiteTemplate template;
            String controller = prop.getProperty("controller", "");
            if (!controller.isEmpty()) {
                try {
                    Constructor<?> c = Class.forName(controller).getConstructor(String.class);
                    template = (SiteTemplate)c.newInstance("screen.pay." + path);
                }
                catch (Throwable throwable) {
                    GuiNotifier.notifyError(throwable);
                    template = new DefaultSiteTemplate("screen.pay." + path);
                }
            } else {
                template = new DefaultSiteTemplate("screen.pay." + path);
            }
            ResourceLoader.load(Locator.getUrl("/gui/skin/{name}//screen/pay/" + path + "/template.fxml"), template);
            template.init();
            CommonScreen screen = null;
            String screenName = prop.getProperty("screen", "");
            if (!screenName.isEmpty()) {
                try {
                    Constructor<?> c = Class.forName(screenName).getConstructor(SiteTemplate.class);
                    screen = (CommonScreen)c.newInstance(template);
                }
                catch (Throwable throwable) {
                    GuiNotifier.notifyError(throwable);
                    screen = new SiteScreen(template);
                }
            } else {
                screen = new SiteScreen(template);
            }
            return screen;
        }
        catch (FxInitException | LoadTemplateException ex) {
            GuiNotifier.notifyError(ex);
            throw new ScreenCreateException("Erron on create info screen: " + path, ex);
        }
    }
}

