/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.selector;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.IntStream;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.Pane;
import javafx.scene.web.WebView;
import plfx.element.ButtonListener;
import plfx.element.FxInitException;
import plfx.element.SButton;
import plfx.screen.input.selector.BaseSelectorTemplate;
import plfx.screen.input.selector.SelectorTemplateListener;
import ru.softlogic.input.model.field.selector.SelectorItem;

public class VariantSelectorTemplate
extends BaseSelectorTemplate {
    private final List<VariantButton> buttons = new LinkedList<VariantButton>();
    private SButton prevPageBtn;
    private SButton nextPageBtn;
    private List<SelectorItem> items;
    private SelectorTemplateListener stlistener;
    private int pageNo;
    private int pageCount;
    protected int selectedIdx;

    public VariantSelectorTemplate(String screenId, String bundleId) {
        super(screenId, bundleId);
    }

    @Override
    public void init() throws FxInitException {
        super.init();
        this.selectedIdx = -1;
        this.prevPageBtn = this.searchButton("browsePrevButton");
        this.prevPageBtn.setListener(() -> {
            if (this.pageNo > 0) {
                --this.pageNo;
                this.rebuildPage();
            }
        });
        this.nextPageBtn = this.searchButton("browseNextButton");
        this.nextPageBtn.setListener(() -> {
            if (this.pageNo < this.pageCount) {
                ++this.pageNo;
                this.rebuildPage();
            }
        });
        for (int i = 0; i < 50; ++i) {
            Node oButton = this.searchNode("selector" + i);
            Node oPane = this.searchNode("helpPane" + i);
            Node oView = this.searchNode("help" + i);
            if (oButton == null || oPane == null || oView == null) break;
            this.buttons.add(new VariantButton((Button)oButton, (Pane)oPane, (WebView)oView));
        }
        if (this.nextBtn != null) {
            this.nextBtn.setVisible(false);
        }
    }

    @Override
    public void setItems(List<SelectorItem> items, SelectorTemplateListener listener) {
        this.items = items;
        this.stlistener = listener;
        this.pageNo = 0;
        this.pageCount = items.size() / this.buttons.size() + (items.size() % this.buttons.size() > 0 ? 1 : 0);
        this.selectedIdx = -1;
        this.rebuildPage();
    }

    @Override
    public void select(List<Integer> indexes) {
        this.selectedIdx = -1;
        if (indexes != null && !indexes.isEmpty()) {
            Integer idx = indexes.get(0);
            this.selectedIdx = idx == null ? -1 : idx;
        }
        this.rebuildPage();
    }

    private void rebuildPage() {
        if (this.prevPageBtn != null && this.items != null) {
            this.prevPageBtn.setVisible(this.items.size() > this.buttons.size());
            this.prevPageBtn.setDisable(this.pageNo == 0);
        }
        if (this.nextPageBtn != null && this.items != null) {
            this.nextPageBtn.setVisible(this.items.size() > this.buttons.size());
            this.nextPageBtn.setDisable(this.pageNo == this.pageCount - 1);
        }
        IntStream.range(0, this.buttons.size()).forEach(i -> {
            this.buttons.get(i).setVisible(false);
            this.buttons.get(i).getButton().getStyleClass().remove((Object)"selector-selected");
            if (this.items != null && this.items.size() > this.buttons.size() * this.pageNo + i) {
                SelectorItem item = this.items.get(this.buttons.size() * this.pageNo + i);
                if (this.buttons.size() * this.pageNo + i == this.selectedIdx) {
                    this.buttons.get(i).getButton().getStyleClass().add((Object)"selector-selected");
                }
                this.buttons.get(i).setText(item.getTitle());
                this.buttons.get(i).setVisible(true);
                this.buttons.get(i).setEnable(item.isEnable());
                this.buttons.get(i).setListener(() -> {
                    if (this.stlistener != null) {
                        this.stlistener.onSelect(item);
                    }
                });
                this.buttons.get(i).setHint(item.getHelp());
            }
        });
    }

    private static class VariantButton {
        private final Button button;
        private final Pane pane;
        private final WebView view;

        public VariantButton(Button button, Pane pane, WebView view) {
            this.button = button;
            this.pane = pane;
            this.view = view;
        }

        public void setText(String text) {
            this.button.setText(text);
        }

        public void setVisible(boolean visible) {
            this.button.setVisible(visible);
            this.pane.setVisible(visible);
            this.view.setVisible(visible);
        }

        public void setEnable(boolean enable) {
            this.button.setDisable(!enable);
            this.pane.setDisable(!enable);
            this.view.setDisable(!enable);
        }

        void setListener(ButtonListener listener) {
            this.button.setOnAction(e -> listener.onAction());
        }

        void setHint(String text) {
            this.view.getEngine().loadContent(text);
        }

        public Button getButton() {
            return this.button;
        }
    }
}

