/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.selector;

import java.util.ArrayList;
import plfx.input.keyboard.KeyboardListener;
import plfx.model.action.ActionNotifier;
import plfx.screen.BaseCommonScreen;
import plfx.screen.FxScreenTemplate;
import plfx.screen.ScreenInit;
import plfx.screen.ScreenListener;
import plfx.screen.input.selector.SelectorActionListener;
import plfx.screen.input.selector.SelectorActionNotifier;
import plfx.screen.input.selector.SelectorTemplate;
import plfx.screen.input.selector.SelectorTemplateListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.Field;
import ru.softlogic.input.model.field.FieldType;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.selector.SelectorField;
import ru.softlogic.input.model.field.selector.SelectorItem;
import ru.softlogic.input.model.screen.description.ScreenDescription;

public class SelectorScreen
extends BaseCommonScreen {
    private SelectorTemplate tpl;
    private SelectorActionNotifier notifier;

    public SelectorScreen(SelectorTemplate tpl) {
        if (tpl == null) {
            throw new NullPointerException("SelectorButtonTemplate");
        }
        this.tpl = tpl;
        this.notifier = new SelectorActionNotifier(this);
        tpl.getBackButton().setListener(new SelectorActionListener("prev", this.notifier, null));
        tpl.getExitButton().setListener(new SelectorActionListener("exit", this.notifier, null));
        tpl.getActions().forEach((a, b) -> b.setListener(() -> this.notifier.notify((String)a)));
    }

    @Override
    protected void _init(ScreenDescription sd, ScreenInit si) throws InitException {
        if (sd.getSequence().getFields() == null || sd.getSequence().getFields().size() != 1) {
            throw new InitException("Screen must have one field");
        }
        this.tpl.initButtons(sd.getButtons());
        Field field = (Field)sd.getSequence().initFields(si.getModelEnvironment()).get(0);
        if (field.getType() != FieldType.Selector) {
            throw new InitException("Field has wrong type");
        }
        SelectorField sf = (SelectorField)sd.getSequence().getFields().get(0);
        this.tpl.setItems(sf.getItems(), new LocalTemplateListener());
        Object get = si.getModelEnvironment().getData().get(sf.getId());
        if (get instanceof InputElement) {
            InputElement ie = (InputElement)get;
            String value = ie.getValue();
            String valueTitle = ie.getValueTitle();
            for (int i = 0; i < sf.getItems().size(); ++i) {
                if (value == null || !value.equals(((SelectorItem)sf.getItems().get(i)).getValue()) || valueTitle == null || !valueTitle.equals(((SelectorItem)sf.getItems().get(i)).getTitle())) continue;
                ArrayList<Integer> idxs = new ArrayList<Integer>();
                idxs.add(i);
                this.tpl.select(idxs);
                break;
            }
        }
        this.notifier.init();
        this.notifier.setField(sf);
        this.tpl.setServiceLogo(sd.getIcon(), sd.getStyleClass());
        if (this.tpl.getNavigation() != null) {
            this.tpl.getNavigation().init(sd.getNavigations(), this.notifier);
        }
    }

    @Override
    public void setListener(ScreenListener listener) {
        this.notifier.setListener(listener);
    }

    @Override
    public KeyboardListener getKeyboardListener() {
        return null;
    }

    @Override
    public FxScreenTemplate getTemplate() {
        return this.tpl;
    }

    @Override
    protected ActionNotifier getActionNotifier() {
        return this.notifier;
    }

    private class LocalTemplateListener
    implements SelectorTemplateListener {
        private LocalTemplateListener() {
        }

        @Override
        public void onSelect(SelectorItem item) {
            SelectorScreen.this.notifier.setItem(item);
            SelectorScreen.this.notifier.notify("next");
        }
    }
}

