/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.selector;

import java.util.LinkedHashMap;
import java.util.List;
import plfx.model.action.LockableActionNotifier;
import plfx.screen.Screen;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.input.model.field.selector.SelectorField;
import ru.softlogic.input.model.field.selector.SelectorItem;

public class SelectorActionNotifier
extends LockableActionNotifier {
    private SelectorField field;
    private SelectorItem item;

    public SelectorActionNotifier(Screen screen) {
        super("SelectorActionNotifier", screen);
    }

    public void setField(SelectorField field) {
        this.field = field;
    }

    public void setItem(SelectorItem item) {
        this.item = item;
    }

    @Override
    protected void _notify(String type) {
        if (this.listener != null) {
            LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
            if (this.item != null && this.field != null) {
                data.put(this.field.getId(), new InputElement(this.field.getId(), this.field.getTitle(), this.field.getTitleId(), this.item.getValue(), this.item.getTitle(), this.field.getFlags()));
                if (this.item.getData() != null) {
                    Data d = this.item.getData();
                    StoreHelper.mergeData(data, (List)d.getElements());
                    if (d.getNestedData() != null) {
                        data.put(d.getNestedData().getId(), d.getNestedData().getData());
                    }
                    if (d.getSum() != null) {
                        data.put("#sum", d.getSum());
                    }
                }
                if (this.item.getCustomData() != null) {
                    data.putAll(this.item.getCustomData());
                }
            }
            this.listener.onAction(type, data, this);
        }
    }

    @Override
    protected String getAdditionalLockInfo() {
        if (this.field == null) {
            return null;
        }
        return "fieldId: " + this.field.getId() + ", title: " + this.field;
    }
}

