/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.selector;

import java.util.List;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import plfx.element.FxInitException;
import plfx.screen.input.selector.BaseSelectorTemplate;
import plfx.screen.input.selector.SelectorTemplateListener;
import ru.softlogic.input.model.field.selector.SelectorItem;

public class ListSelectorTemplate
extends BaseSelectorTemplate {
    @FXML
    private ListView<SelectorItem> listView;
    private SelectorTemplateListener listener;

    public ListSelectorTemplate(String screenId, String bundleId) {
        super(screenId, bundleId);
    }

    @Override
    public void init() throws FxInitException {
        super.init();
        MultipleSelectionModel model = this.listView.getSelectionModel();
        this.listView.setCellFactory(param -> new ListCellImpl());
        this.listView.setOnMouseClicked(t -> {
            if (model.getSelectedIndex() >= 0) {
                this.setButtonState(true);
            }
        });
        this.nextBtn.setListener(() -> {
            if (this.listener != null) {
                this.listener.onSelect((SelectorItem)model.getSelectedItem());
            }
        });
    }

    @Override
    public void setItems(List<SelectorItem> items, SelectorTemplateListener listener) {
        this.listener = listener;
        this.setButtonState(false);
        this.listView.getItems().clear();
        this.listView.setItems(FXCollections.observableArrayList(items));
        this.listView.getSelectionModel().clearSelection();
    }

    @Override
    public void select(List<Integer> indexes) {
        int selectedIdx = -1;
        if (indexes != null && !indexes.isEmpty()) {
            Integer idx = indexes.get(0);
            selectedIdx = idx == null ? -1 : idx;
        }
        this.listView.getSelectionModel().clearSelection();
        this.listView.getSelectionModel().select(selectedIdx);
        if (this.listView.getSelectionModel().getSelectedIndex() >= 0) {
            this.setButtonState(true);
        }
    }

    private void setButtonState(boolean active) {
        this.nextBtn.setDisable(!active);
    }

    private static class ListCellImpl
    extends ListCell<SelectorItem> {
        private ListCellImpl() {
        }

        protected void updateItem(SelectorItem item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (item != null) {
                this.setText(item.getTitle());
                this.setDisable(!item.isEnable());
            } else {
                this.setText(null);
                this.setDisable(true);
            }
        }
    }
}

