/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.selector;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.IntStream;
import plfx.element.FxInitException;
import plfx.element.SButton;
import plfx.screen.input.selector.BaseSelectorTemplate;
import plfx.screen.input.selector.SelectorTemplateListener;
import plfx.util.Locator;
import ru.softlogic.input.model.field.selector.SelectorItem;

public class ImageSelectorTemplate
extends BaseSelectorTemplate {
    private final List<SButton> buttons = new LinkedList<SButton>();
    private SButton prevPageBtn;
    private SButton nextPageBtn;
    private List<SelectorItem> items;
    private SelectorTemplateListener stlistener;
    private int pageNo;
    private int pageCount;
    protected int selectedIdx;

    public ImageSelectorTemplate(String screenId, String bundleId) {
        super(screenId, bundleId);
    }

    @Override
    public void init() throws FxInitException {
        SButton btn;
        super.init();
        this.selectedIdx = -1;
        this.prevPageBtn = this.searchButton("browsePrevButton");
        this.prevPageBtn.setListener(() -> {
            if (this.pageNo > 0) {
                --this.pageNo;
                this.rebuildPage();
            }
        });
        this.nextPageBtn = this.searchButton("browseNextButton");
        this.nextPageBtn.setListener(() -> {
            if (this.pageNo < this.pageCount) {
                ++this.pageNo;
                this.rebuildPage();
            }
        });
        for (int i = 0; i < 50 && (btn = this.searchButton("selector" + i, false)) != null; ++i) {
            this.buttons.add(btn);
        }
        if (this.nextBtn != null) {
            this.nextBtn.setVisible(false);
        }
    }

    @Override
    public void setItems(List<SelectorItem> items, SelectorTemplateListener listener) {
        this.items = items;
        this.stlistener = listener;
        this.pageNo = 0;
        this.pageCount = items.size() / this.buttons.size() + (items.size() % this.buttons.size() > 0 ? 1 : 0);
        this.selectedIdx = -1;
        this.rebuildPage();
    }

    @Override
    public void select(List<Integer> indexes) {
        this.selectedIdx = -1;
        if (indexes != null && !indexes.isEmpty()) {
            Integer idx = indexes.get(0);
            this.selectedIdx = idx == null ? -1 : idx;
        }
        this.rebuildPage();
    }

    private void rebuildPage() {
        if (this.prevPageBtn != null && this.items != null) {
            this.prevPageBtn.setVisible(this.items.size() > this.buttons.size());
            this.prevPageBtn.setDisable(this.pageNo == 0);
        }
        if (this.nextPageBtn != null && this.items != null) {
            this.nextPageBtn.setVisible(this.items.size() > this.buttons.size());
            this.nextPageBtn.setDisable(this.pageNo == this.pageCount - 1);
        }
        IntStream.range(0, this.buttons.size()).forEach(i -> {
            this.buttons.get(i).setVisible(false);
            this.buttons.get(i).getNode().getStyleClass().remove((Object)"selector-selected");
            if (this.items != null && this.items.size() > this.buttons.size() * this.pageNo + i) {
                SelectorItem item = this.items.get(this.buttons.size() * this.pageNo + i);
                String path = Locator.getPath("/gui/skin/{name}/img/" + item.getImage());
                if (path != null) {
                    this.buttons.get(i).setImage(path);
                } else {
                    this.buttons.get(i).setImage(null);
                }
                if (this.buttons.size() * this.pageNo + i == this.selectedIdx) {
                    this.buttons.get(i).getNode().getStyleClass().add((Object)"selector-selected");
                }
                this.buttons.get(i).setText(item.getTitle());
                this.buttons.get(i).setVisible(true);
                this.buttons.get(i).setDisable(!item.isEnable());
                this.buttons.get(i).setListener(() -> {
                    if (this.stlistener != null) {
                        this.stlistener.onSelect(item);
                    }
                });
            }
        });
    }
}

