/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.selector;

import java.lang.reflect.Constructor;
import java.util.Properties;
import plfx.GuiNotifier;
import plfx.element.FxInitException;
import plfx.screen.CommonScreen;
import plfx.screen.CommonScreenFactory;
import plfx.screen.ScreenCreateException;
import plfx.screen.input.selector.ButtonSelectorTemplate;
import plfx.screen.input.selector.SelectorScreen;
import plfx.screen.input.selector.SelectorTemplate;
import plfx.util.LoadTemplateException;
import plfx.util.Locator;
import plfx.util.ResourceLoader;

public class DefaultSelectorFactory
implements CommonScreenFactory {
    @Override
    public CommonScreen create(String path, Properties prop) throws ScreenCreateException {
        try {
            CommonScreen screen;
            SelectorTemplate template;
            String controller = prop.getProperty("controller", "");
            if (!controller.isEmpty()) {
                try {
                    Constructor<?> c = Class.forName(controller).getConstructor(String.class, String.class);
                    template = (SelectorTemplate)c.newInstance("screen.pay." + path, path.startsWith("@") ? "ext" : "skin");
                }
                catch (Throwable throwable) {
                    GuiNotifier.notifyError(throwable);
                    template = new ButtonSelectorTemplate("screen.pay." + path, path.startsWith("@") ? "ext" : "skin");
                }
            } else {
                template = new ButtonSelectorTemplate("screen.pay." + path, path.startsWith("@") ? "ext" : "skin");
            }
            if (path.startsWith("@")) {
                ResourceLoader.load(Locator.getUrl("/gui/system/screen/" + path.substring(1) + "/template.fxml"), template);
            } else {
                ResourceLoader.load(Locator.getFileUrl("/gui/skin/{name}//screen/pay/" + path + "/template.fxml"), template);
            }
            template.init();
            String screenName = prop.getProperty("screen", "");
            if (!screenName.isEmpty()) {
                try {
                    Constructor<?> c = Class.forName(screenName).getConstructor(SelectorTemplate.class);
                    screen = (CommonScreen)c.newInstance(template);
                }
                catch (Throwable throwable) {
                    GuiNotifier.notifyError(throwable);
                    screen = new SelectorScreen(template);
                }
            } else {
                screen = new SelectorScreen(template);
            }
            return screen;
        }
        catch (FxInitException | LoadTemplateException ex) {
            GuiNotifier.notifyError(ex);
            throw new ScreenCreateException("Erron on create selector screen: " + path, ex);
        }
    }
}

