/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.numeric;

import plfx.element.SButton;
import plfx.element.SLabel;
import plfx.model.textfield.FieldListener;
import ru.softlogic.input.model.field.numeric.NumericField;

public class ValidateNumericListener
implements FieldListener {
    private final SButton sb;
    private final SLabel sl;
    private final NumericField nf;
    private final String regex;

    public ValidateNumericListener(SButton sb, SLabel sl, NumericField nf) {
        this.sb = sb;
        this.sl = sl;
        this.nf = nf;
        this.regex = nf.getDecimalCount() > 0 ? "^\\d{" + nf.getUnitCount() + "}((\\.|,)\\d{" + nf.getDecimalCount() + "})?$" : "^\\d{" + nf.getUnitCount() + "}$";
    }

    @Override
    public void onChange(String value) {
        boolean valid = this.nf.getValidator().validate(value);
        this.sb.setDisable(!valid);
        this.sl.setVisible(value.matches(this.regex) && !valid);
    }

    @Override
    public void onEnter(String value) {
    }
}

