/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.numeric;

import plfx.input.keyboard.KeyboardListener;
import plfx.input.keyboard.digital.DigitalKeyboard;
import plfx.model.action.ActionNotifier;
import plfx.model.action.NumericActionNotifier;
import plfx.model.textfield.InputFieldModel;
import plfx.model.textfield.NumericFieldModel;
import plfx.model.textfield.TextFieldModel;
import plfx.screen.BaseCommonScreen;
import plfx.screen.FxScreenTemplate;
import plfx.screen.ScreenInit;
import plfx.screen.ScreenListener;
import plfx.screen.ScreenListenerAdapter;
import plfx.screen.input.numeric.ComplexKeyboardListener;
import plfx.screen.input.numeric.NumericTemplate;
import plfx.screen.input.numeric.UpdateListener;
import plfx.screen.input.numeric.ValidateNumericListener;
import plfx.screen.input.numeric.ValidateTextListener;
import plfx.screen.pay.ButtonActionListener;
import ru.softlogic.input.model.field.Field;
import ru.softlogic.input.model.field.FieldType;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.InputField;
import ru.softlogic.input.model.field.numeric.NumericField;
import ru.softlogic.input.model.field.text.Formatter;
import ru.softlogic.input.model.field.text.TextField;
import ru.softlogic.input.model.field.text.VoidFormatter;
import ru.softlogic.input.model.screen.description.ScreenDescription;

public class NumericScreen
extends BaseCommonScreen {
    private NumericTemplate tpl;
    private ComplexKeyboardListener keyListener;
    private DigitalKeyboard keyboard;
    private InputFieldModel model;
    private InputField inputField;
    private NumericActionNotifier notifier;

    public NumericScreen(NumericTemplate tpl) {
        if (tpl == null) {
            throw new NullPointerException("NumericTemplate");
        }
        this.tpl = tpl;
        this.keyboard = tpl.getDigitalKeyboard();
        this.keyboard.setExtraButtonX(null);
        this.keyboard.setExtraButtonC(null);
        this.notifier = new NumericActionNotifier(this);
        this.keyListener = new ComplexKeyboardListener(this.notifier);
        this.keyboard.setKeyboardListener(this.keyListener);
        tpl.getBackButton().setListener(new ButtonActionListener("prev", this.notifier));
        tpl.getExitButton().setListener(new ButtonActionListener("exit", this.notifier));
        tpl.getNextButton().setListener(new ButtonActionListener("next", this.notifier));
        tpl.getActions().forEach((a, b) -> b.setListener(() -> this.notifier.notify((String)a)));
    }

    @Override
    protected void _init(ScreenDescription sd, ScreenInit si) throws InitException {
        if (sd.getSequence() == null) {
            throw new NullPointerException("Field sequence is not specify");
        }
        if (sd.getSequence().getFields() == null || sd.getSequence().getFields().size() != 1) {
            throw new InitException("Screen must have one field");
        }
        this.tpl.initButtons(sd.getButtons());
        Field field = (Field)sd.getSequence().initFields(si.getModelEnvironment()).get(0);
        if (field.getType() != FieldType.Numeric && field.getType() != FieldType.Letter) {
            throw new InitException("Field has wrong type");
        }
        if (field.isNumeric()) {
            NumericField nf = (NumericField)field;
            this.inputField = nf;
            this.model = new NumericFieldModel(nf.getUnitCount(), nf.getDecimalCount(), nf.isReadOnly(), nf.getFilter());
            this.model.addListener(new UpdateListener(this.tpl, (Formatter)new VoidFormatter()));
            this.model.addListener(new ValidateNumericListener(this.tpl.getNextButton(), this.tpl.getErrorLabel(), nf));
        } else {
            TextField tf = (TextField)field;
            this.inputField = tf;
            this.model = new TextFieldModel(tf.getMaxLength(), tf.getPrefix(), tf.getPostfix(), tf.isReadOnly(), tf.getFilter());
            this.model.addListener(new UpdateListener(this.tpl, tf.getViewFormatter(), tf.isSecure()));
            this.model.addListener(new ValidateTextListener(this.tpl.getNextButton(), this.tpl.getErrorLabel(), tf));
        }
        this.keyListener.setModel(this.model);
        this.notifier.init();
        this.notifier.setField(this.inputField);
        this.notifier.setModel(this.model);
        this.keyboard.init(this.inputField.getKeyboard());
        this.model.setValue(this.inputField.getValue());
        this.tpl.setServiceLogo(sd.getIcon(), sd.getStyleClass());
        if (this.tpl.getNavigation() != null) {
            this.tpl.getNavigation().init(sd.getNavigations(), this.notifier);
        }
    }

    @Override
    public void setListener(ScreenListener listener) {
        this.notifier.setListener(listener);
        this.tpl.setListener(new ScreenListenerAdapter(listener));
    }

    @Override
    public KeyboardListener getKeyboardListener() {
        return this.keyListener;
    }

    @Override
    public FxScreenTemplate getTemplate() {
        return this.tpl;
    }

    @Override
    protected ActionNotifier getActionNotifier() {
        return this.notifier;
    }
}

