/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.numeric;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import plfx.GuiNotifier;
import plfx.element.FxInitException;
import plfx.screen.CommonScreen;
import plfx.screen.CommonScreenFactory;
import plfx.screen.ScreenCreateException;
import plfx.screen.input.numeric.DefaultNumericTemplate;
import plfx.screen.input.numeric.NumericScreen;
import plfx.screen.input.numeric.NumericTemplate;
import plfx.util.LoadTemplateException;
import plfx.util.Locator;
import plfx.util.ResourceLoader;

public class DefaultNumericFactory
implements CommonScreenFactory {
    @Override
    public CommonScreen create(String path, Properties prop) throws ScreenCreateException {
        try {
            CommonScreen screen;
            NumericTemplate template;
            String controller = prop.getProperty("controller", "");
            if (!controller.isEmpty()) {
                try {
                    Constructor<?> c = Class.forName(controller).getConstructor(String.class, String.class);
                    template = (NumericTemplate)c.newInstance("screen.pay." + path, path.startsWith("@") ? "ext" : "skin");
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException throwable) {
                    GuiNotifier.notifyError(throwable);
                    template = new DefaultNumericTemplate("screen.pay." + path, path.startsWith("@") ? "ext" : "skin");
                }
            } else {
                template = new DefaultNumericTemplate("screen.pay." + path, path.startsWith("@") ? "ext" : "skin");
            }
            if (path.startsWith("@")) {
                ResourceLoader.load(Locator.getUrl("/gui/system/screen/" + path.substring(1) + "/template.fxml"), template);
            } else {
                ResourceLoader.load(Locator.getFileUrl("/gui/skin/{name}//screen/pay/" + path + "/template.fxml"), template);
            }
            template.init();
            String screenName = prop.getProperty("screen", "");
            if (!screenName.isEmpty()) {
                try {
                    Constructor<?> c = Class.forName(screenName).getConstructor(NumericTemplate.class);
                    screen = (CommonScreen)c.newInstance(template);
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException throwable) {
                    GuiNotifier.notifyError(throwable);
                    screen = new NumericScreen(template);
                }
            } else {
                screen = new NumericScreen(template);
            }
            return screen;
        }
        catch (FxInitException | LoadTemplateException ex) {
            GuiNotifier.notifyError(ex);
            throw new ScreenCreateException("Erron on create numeric screen: " + path, ex);
        }
    }
}

