/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.info;

import java.util.Objects;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import plfx.input.keyboard.KeyboardListener;
import plfx.input.webcam.WebcamListener;
import plfx.model.action.ActionNotifier;
import plfx.model.action.VoidActionNotifier;
import plfx.screen.CommonScreen;
import plfx.screen.FxScreenTemplate;
import plfx.screen.ScreenInit;
import plfx.screen.ScreenListener;
import plfx.screen.input.info.InfoTemplate;
import plfx.screen.pay.ButtonActionListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.screen.Event;
import ru.softlogic.input.model.screen.EventRule;
import ru.softlogic.input.model.screen.description.InfoScreenDescription;
import ru.softlogic.input.model.screen.description.ScreenDescription;

class InfoScreen
implements CommonScreen,
WebcamListener {
    private final InfoTemplate tpl;
    private final VoidActionNotifier notifier;
    private ScreenDescription sd;

    public InfoScreen(InfoTemplate tpl) {
        this.tpl = Objects.requireNonNull(tpl, "InfoTemplate");
        this.notifier = new VoidActionNotifier(this);
        tpl.getBackButton().setListener(new ButtonActionListener("prev", this.notifier));
        tpl.getExitButton().setListener(new ButtonActionListener("exit", this.notifier));
        tpl.getNextButton().setListener(new ButtonActionListener("next", this.notifier));
        tpl.getActions().forEach((a, b) -> b.setListener(() -> this.notifier.notify((String)a)));
    }

    @Override
    public void init(ScreenDescription sd, ScreenInit si) throws InitException {
        String info;
        if (sd instanceof InfoScreenDescription) {
            this.sd = sd;
            InfoScreenDescription isd = (InfoScreenDescription)sd;
            info = null;
            if (isd.getKey() != null) {
                Object element = si.getModelEnvironment().getData().get(isd.getKey());
                if (element instanceof InputElement) {
                    InputElement ie = (InputElement)element;
                    info = ie.getValue();
                }
            } else {
                info = isd.getInfo();
            }
        } else {
            throw new InitException("Wrong ScreenDescription");
        }
        this.tpl.getMessageLabel().setText(info != null ? info : "");
        this.notifier.init();
        if (this.tpl.getNavigation() != null) {
            this.tpl.getNavigation().init(sd.getNavigations(), this.notifier);
        }
        this.tpl.initButtons(sd.getButtons());
        this.tpl.setServiceLogo(sd.getIcon(), sd.getStyleClass());
        this.tpl.initButtons(sd.getButtons());
    }

    @Override
    public void setListener(ScreenListener listener) {
        this.notifier.setListener(listener);
    }

    @Override
    public KeyboardListener getKeyboardListener() {
        return null;
    }

    @Override
    public FxScreenTemplate getTemplate() {
        return this.tpl;
    }

    @Override
    public WebcamListener getWebcamListener() {
        return this;
    }

    @Override
    public void onImage(WritableImage image) {
        this.tpl.getMessageLabel().setImage((Image)image);
    }

    @Override
    public void onError() {
    }

    @Override
    public void onEvent(Event event) {
        Objects.requireNonNull(event, "Event is null");
        if (this.sd == null || this.sd.getEventRules() == null) {
            return;
        }
        ActionNotifier an = this.getActionNotifier();
        if (an == null) {
            return;
        }
        for (EventRule er : this.sd.getEventRules()) {
            if (!event.equals((Object)er.getEvent())) continue;
            an.notify(er.getActionId());
            return;
        }
    }

    protected ActionNotifier getActionNotifier() {
        return this.notifier;
    }
}

