/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.group;

import java.util.Map;
import javafx.event.EventHandler;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.OverrunStyle;
import javafx.scene.input.MouseEvent;
import plfx.model.textfield.FieldListener;
import plfx.model.textfield.InputFieldModel;
import plfx.model.textfield.TextFieldModel;
import plfx.screen.input.group.InputComponent;
import plfx.screen.input.group.InputComponentListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.text.TextField;

public class TextInputComponent
implements InputComponent,
EventHandler<MouseEvent> {
    protected TextField field;
    protected Label component;
    protected InputFieldModel model;
    protected InputComponentListener listener;
    protected boolean selected;
    protected boolean warning;
    protected boolean example;
    protected boolean valid;
    protected int index;

    public TextInputComponent(Label component, TextField field, Object oValue, InputComponentListener listener, int index) {
        this.field = field;
        this.listener = listener;
        this.component = component;
        this.index = index;
        component.getStyleClass().add((Object)"element-label");
        component.getStyleClass().add((Object)"label");
        component.setOnMousePressed((EventHandler)this);
        this.model = new TextFieldModel(field.getMaxLength(), field.getPrefix(), field.getPostfix(), field.isReadOnly(), field.getFilter());
        this.model.addListener(new ChangeFieldListener());
        if (oValue instanceof InputElement) {
            InputElement ie = (InputElement)oValue;
            if (ie.getOriginalValue() != null) {
                this.model.setValue(ie.getOriginalValue());
            } else {
                this.model.setValue(ie.getValue());
            }
        } else {
            this.model.setValue(field.getValue());
        }
        this.processExample();
        this.updateStyle();
    }

    @Override
    public boolean isValid() {
        String value = this.model.getValue();
        this.valid = this.field.getValidator().validate(value);
        String failRegex = this.field.getFailRegex();
        if (!this.valid && failRegex != null && !failRegex.isEmpty()) {
            this.valid = value.matches(failRegex);
        }
        this.setWarning(!value.isEmpty() && !this.valid);
        return this.valid;
    }

    @Override
    public void putData(Map<String, Object> data) {
        InputElement ie = new InputElement(this.field.getId(), this.field.getTitle(), this.field.getTitleId(), this.model.getClearValue(), this.field.getModificator().modify(this.model.getValue()), this.example ? "" : this.component.getText(), this.field.getFlags());
        data.put(this.field.getId(), ie);
        String failRegex = this.field.getFailRegex();
        if (!this.field.getValidator().validate(this.model.getValue()) && failRegex != null && !failRegex.isEmpty() && this.model.getValue().matches(failRegex)) {
            data.put("#invalid", "true");
        }
    }

    public String toString() {
        return "TextInputComponent{field=" + this.field + '}';
    }

    @Override
    public void getFocus() {
        this.selected = true;
        this.component.setTextOverrun(OverrunStyle.LEADING_ELLIPSIS);
        this.listener.onSelect(this, this.model, this.field.getKeyboard());
        this.updateStyle();
    }

    @Override
    public void onLostFocus() {
        this.selected = false;
        this.component.setTextOverrun(OverrunStyle.ELLIPSIS);
        this.updateStyle();
    }

    @Override
    public void setWarning(boolean warning) {
        this.warning = warning;
        this.updateStyle();
    }

    public void handle(MouseEvent t) {
        this.getFocus();
    }

    private void updateStyle() {
        this.component.getStyleClass().remove((Object)"element-label-selected");
        this.component.getStyleClass().remove((Object)"element-label-error");
        this.component.getStyleClass().remove((Object)"element-label-example");
        if (this.selected) {
            this.component.getStyleClass().add((Object)"element-label-selected");
        }
        if (this.warning) {
            this.component.getStyleClass().add((Object)"element-label-error");
        }
        if (this.example) {
            this.component.getStyleClass().add((Object)"element-label-example");
        }
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void update(Map<String, Object> data) {
        Object obj = data.get(this.field.getId());
        if (obj instanceof InputElement) {
            InputElement ie = (InputElement)obj;
            if (ie.getOriginalValue() != null) {
                this.model.setValue(ie.getOriginalValue());
            } else {
                this.model.setValue(ie.getValue());
            }
            this.updateStyle();
        }
    }

    @Override
    public Control getControl() {
        return this.component;
    }

    private void processExample() {
        String exampleValue = this.field.getExampleValue();
        String value = this.model.getValue();
        if (exampleValue != null && !exampleValue.isEmpty() && (value == null || value.isEmpty())) {
            this.example = true;
            this.component.setText(exampleValue);
        } else {
            this.example = false;
        }
    }

    private final class ChangeFieldListener
    implements FieldListener {
        private ChangeFieldListener() {
        }

        @Override
        public void onChange(String value) {
            if (TextInputComponent.this.field.isSecure() && value != null) {
                value = value.replaceAll("\\W{1}|\\w{1}", "*");
            }
            TextInputComponent.this.component.setText(TextInputComponent.this.field.getViewFormatter().format(value));
            TextInputComponent.this.processExample();
            TextInputComponent.this.listener.onChange();
        }

        @Override
        public void onEnter(String value) {
        }
    }
}

