/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.group;

import java.util.Map;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import plfx.msg.MessageProcessor;
import plfx.screen.input.group.InputComponent;
import plfx.screen.input.group.InputComponentListener;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.selector.SelectorField;
import ru.softlogic.input.model.field.selector.SelectorItem;

public class SelectorInputComponent
implements InputComponent,
EventHandler<ActionEvent> {
    protected final SelectorField field;
    protected ComboBox<String> component;
    private InputComponentListener listener;
    private int index;
    protected boolean selected;
    protected boolean warning;
    protected boolean valid;

    public SelectorInputComponent(ComboBox<String> component, SelectorField field, Object value, InputComponentListener listener, int index) {
        this.component = component;
        this.field = field;
        this.listener = listener;
        this.index = index;
        component.getStyleClass().add((Object)"element-combobox");
        component.setVisibleRowCount(10);
        InputElement ie = null;
        if (value != null && value instanceof InputElement) {
            ie = (InputElement)value;
        }
        int select = -1;
        component.getItems().clear();
        for (int i = 0; i < field.getItems().size(); ++i) {
            SelectorItem si = (SelectorItem)field.getItems().get(i);
            String title = MessageProcessor.getFormMessage(si.getTitleId(), si.getTitle());
            component.getItems().add((Object)title);
            if (ie == null || ie.getValue() == null || !ie.getValue().equals(si.getValue()) || ie.getValueTitle() == null || !ie.getValueTitle().equals(si.getTitle())) continue;
            select = i;
        }
        if (select >= 0) {
            component.getSelectionModel().select(select);
        } else if (field.getSelectedIndex() != null && field.getSelectedIndex() < component.getItems().size()) {
            component.getSelectionModel().select(field.getSelectedIndex().intValue());
        } else {
            component.getSelectionModel().clearSelection();
        }
        component.setOnAction((EventHandler)this);
        component.setOnMousePressed(t -> this.getFocus());
        this.updateStyle();
    }

    @Override
    public boolean isValid() {
        this.valid = this.component.getSelectionModel().getSelectedItem() != null;
        return this.valid;
    }

    @Override
    public void putData(Map<String, Object> data) {
        int id = this.component.getSelectionModel().getSelectedIndex();
        if (id >= 0) {
            Data d;
            SelectorItem si = (SelectorItem)this.field.getItems().get(id);
            data.put(this.field.getId(), new InputElement(this.field.getId(), this.field.getTitle(), this.field.getTitleId(), si.getValue(), si.getTitle(), this.field.getFlags()));
            if (si.getData() != null && (d = si.getData()) != null && d.getElements() != null) {
                for (InputElement el : d.getElements()) {
                    data.put(el.getKey(), el);
                }
                if (d.getNestedData() != null) {
                    data.put(d.getNestedData().getId(), d.getNestedData().getData());
                }
                if (d.getSum() != null) {
                    data.put("#sum", d.getSum());
                }
            }
        }
    }

    @Override
    public final void getFocus() {
        this.selected = true;
        this.listener.onSelect(this, null, null);
        this.updateStyle();
    }

    @Override
    public void onLostFocus() {
        this.selected = false;
        this.updateStyle();
    }

    public SelectorInputComponent(SelectorField field) {
        this.field = field;
    }

    public String toString() {
        return "SelectorInputComponent{field=" + this.field + '}';
    }

    @Override
    public void setWarning(boolean warning) {
        this.warning = warning;
        this.updateStyle();
    }

    public void handle(ActionEvent t) {
        this.listener.onChange();
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    private void updateStyle() {
        this.component.getStyleClass().remove((Object)"element-combobox-selected");
        this.component.getStyleClass().remove((Object)"element-combobox-error");
        if (this.selected) {
            this.component.getStyleClass().add((Object)"element-combobox-selected");
        }
        if (this.warning) {
            this.component.getStyleClass().add((Object)"element-combobox-error");
        }
    }

    @Override
    public void update(Map<String, Object> data) {
    }

    @Override
    public Control getControl() {
        return this.component;
    }
}

