/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.group;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Map;
import javafx.event.EventHandler;
import javafx.scene.control.Control;
import javafx.scene.control.OverrunStyle;
import javafx.scene.input.MouseEvent;
import plfx.element.UpDownLable;
import plfx.model.textfield.FieldListener;
import plfx.model.textfield.InputFieldModel;
import plfx.model.textfield.NumericFieldModel;
import plfx.screen.input.group.InputComponent;
import plfx.screen.input.group.InputComponentListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.numeric.NumericField;

public class NumericInputComponent
implements InputComponent,
EventHandler<MouseEvent> {
    protected NumericField field;
    protected UpDownLable component;
    protected InputFieldModel model;
    protected InputComponentListener listener;
    protected boolean selected;
    protected boolean warning;
    protected boolean example;
    protected boolean valid;
    protected int index;

    public NumericInputComponent(UpDownLable component, NumericField field, Object oValue, InputComponentListener listener, int index) {
        this.field = field;
        this.listener = listener;
        this.component = component;
        this.index = index;
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        df.setMinimumFractionDigits(0);
        DecimalFormatSymbols dfs = df.getDecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        df.setDecimalFormatSymbols(dfs);
        df.setGroupingUsed(false);
        component.getLabel().getStyleClass().add((Object)"element-label");
        component.getLabel().getStyleClass().add((Object)"label");
        component.getUp().setText("+");
        component.getDown().setText("-");
        component.getUp().getStyleClass().add((Object)"element-label-button");
        component.getDown().getStyleClass().add((Object)"element-label-button");
        component.setOnMousePressed(this);
        this.model = new NumericFieldModel(field.getUnitCount(), field.getDecimalCount(), field.isReadOnly(), field.getFilter());
        this.model.addListener(new FieldListener(){

            @Override
            public void onChange(String value) {
                NumericInputComponent.this.component.getLabel().setText(value);
                NumericInputComponent.this.processExample();
                NumericInputComponent.this.listener.onChange();
            }

            @Override
            public void onEnter(String value) {
            }
        });
        if (oValue instanceof InputElement) {
            InputElement ie = (InputElement)oValue;
            if (ie.getOriginalValue() != null) {
                this.model.setValue(ie.getOriginalValue());
            } else {
                this.model.setValue(ie.getValue());
            }
        } else {
            this.model.setValue(field.getValue());
        }
        component.getUp().setOnMouseClicked(t -> {
            this.getFocus();
            double v = 0.0;
            String in = this.model.getValue().replace(",", ".");
            if (!in.trim().isEmpty()) {
                try {
                    v = Double.parseDouble(in);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            String out = df.format(v + field.getUpdown());
            this.model.setValue(field.getViewFormatter().format(out));
        });
        component.getDown().setOnMouseClicked(t -> {
            this.getFocus();
            double v = 0.0;
            String in = this.model.getValue().replace(",", ".");
            if (!in.trim().isEmpty()) {
                try {
                    v = Double.parseDouble(in);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (v - field.getUpdown() >= 0.0) {
                String out = df.format(v - field.getUpdown());
                this.model.setValue(field.getViewFormatter().format(out));
            }
        });
        this.processExample();
        this.updateStyle();
    }

    @Override
    public boolean isValid() {
        this.valid = this.field.getValidator().validate(this.model.getValue());
        this.setWarning(!this.model.getValue().isEmpty() && !this.valid);
        return this.valid;
    }

    @Override
    public void putData(Map<String, Object> data) {
        InputElement ie = new InputElement(this.field.getId(), this.field.getTitle(), this.field.getTitleId(), this.model.getValue(), this.field.getModificator().modify(this.model.getValue()), this.example ? "" : this.component.getLabel().getText(), this.field.getFlags());
        data.put(this.field.getId(), ie);
    }

    public String toString() {
        return "NumericInputComponent{field=" + this.field + '}';
    }

    @Override
    public void getFocus() {
        this.selected = true;
        this.component.setTextOverrun(OverrunStyle.LEADING_ELLIPSIS);
        this.listener.onSelect(this, this.model, this.field.getKeyboard());
        this.updateStyle();
    }

    @Override
    public void onLostFocus() {
        this.selected = false;
        this.component.setTextOverrun(OverrunStyle.ELLIPSIS);
        this.updateStyle();
    }

    @Override
    public void setWarning(boolean warning) {
        this.warning = warning;
        this.updateStyle();
    }

    public void handle(MouseEvent t) {
        this.getFocus();
    }

    private void updateStyle() {
        this.component.getLabel().getStyleClass().remove((Object)"element-label-selected");
        this.component.getLabel().getStyleClass().remove((Object)"element-label-error");
        this.component.getLabel().getStyleClass().remove((Object)"element-label-example");
        if (this.selected) {
            this.component.getLabel().getStyleClass().add((Object)"element-label-selected");
        }
        if (this.warning) {
            this.component.getLabel().getStyleClass().add((Object)"element-label-error");
        }
        if (this.example) {
            this.component.getLabel().getStyleClass().add((Object)"element-label-example");
        }
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void update(Map<String, Object> data) {
        Object obj = data.get(this.field.getId());
        if (obj != null && obj instanceof InputElement) {
            InputElement ie = (InputElement)obj;
            if (ie.getOriginalValue() != null) {
                this.model.setValue(ie.getOriginalValue());
            } else {
                this.model.setValue(ie.getValue());
            }
            this.updateStyle();
        }
    }

    @Override
    public Control getControl() {
        return this.component;
    }

    private void processExample() {
        if (this.field.getExampleValue() != null && !this.field.getExampleValue().isEmpty() && (this.model.getValue() == null || this.model.getValue().isEmpty())) {
            this.example = true;
            this.component.getLabel().setText(this.field.getExampleValue());
        } else {
            this.example = false;
        }
    }
}

