/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.group;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Map;
import javafx.event.EventHandler;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.OverrunStyle;
import javafx.scene.input.MouseEvent;
import plfx.model.textfield.FieldListener;
import plfx.model.textfield.InputFieldModel;
import plfx.model.textfield.NumericFieldModel;
import plfx.screen.input.group.InputComponent;
import plfx.screen.input.group.InputComponentListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.numeric.NumericField;

public class MetterComponent
implements InputComponent,
EventHandler<MouseEvent> {
    protected NumericField field;
    protected Label component;
    protected InputFieldModel model;
    protected InputComponentListener listener;
    protected boolean selected;
    protected boolean warning;
    protected int index;
    protected boolean bind;
    protected Double standard;

    public MetterComponent(Label component, NumericField field, Object oValue, InputComponentListener listener, int index) {
        this.field = field;
        this.listener = listener;
        this.component = component;
        this.index = index;
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        df.setMinimumFractionDigits(0);
        DecimalFormatSymbols dfs = df.getDecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        df.setDecimalFormatSymbols(dfs);
        df.setGroupingUsed(false);
        component.getStyleClass().add((Object)"element-label");
        component.setOnMousePressed((EventHandler)this);
        this.model = new NumericFieldModel(field.getUnitCount(), field.getDecimalCount(), field.isReadOnly(), field.getFilter());
        this.model.addListener(new FieldListener(){

            @Override
            public void onChange(String value) {
                MetterComponent.this.component.setText(value);
                if (!MetterComponent.this.bind) {
                    MetterComponent.this.listener.onChange();
                }
            }

            @Override
            public void onEnter(String value) {
            }
        });
        if (oValue instanceof InputElement) {
            InputElement ie = (InputElement)oValue;
            if (ie.getOriginalValue() != null) {
                this.model.setValue(ie.getOriginalValue());
            } else {
                this.model.setValue(ie.getValue());
            }
        } else {
            this.model.setValue(field.getValue());
        }
        component.setOnMouseClicked(t -> this.getFocus());
        this.updateStyle();
    }

    public Double getValue() {
        if (this.model.getValue() != null && !this.model.getValue().isEmpty()) {
            return Double.valueOf(this.model.getValue());
        }
        return null;
    }

    public void setValue(Double value) {
        this.bind = true;
        if (value == null) {
            this.model.setValue(null);
        } else {
            this.model.setValue(value.toString());
        }
        this.bind = false;
    }

    public String getId() {
        return this.field.getId();
    }

    public void setStandard(Double standard) {
        this.standard = standard;
    }

    @Override
    public boolean isValid() {
        if (this.getValue() == null) {
            this.setWarning(false);
            return true;
        }
        boolean valid = this.field.getValidator().validate(this.model.getValue());
        if (valid && this.standard != null) {
            valid = this.getValue() >= this.standard;
        }
        this.setWarning(!this.model.getValue().isEmpty() && !valid);
        return valid;
    }

    @Override
    public void putData(Map<String, Object> data) {
        InputElement ie = new InputElement(this.field.getId(), this.field.getTitle(), this.field.getTitleId(), this.model.getValue(), this.field.getModificator().modify(this.model.getValue()), this.component.getText(), this.field.getFlags());
        data.put(this.field.getId(), ie);
    }

    public String toString() {
        return "NumericInputComponent{field=" + this.field + '}';
    }

    @Override
    public void getFocus() {
        this.selected = true;
        this.component.setTextOverrun(OverrunStyle.LEADING_ELLIPSIS);
        this.listener.onSelect(this, this.model, this.field.getKeyboard());
        this.updateStyle();
    }

    @Override
    public void onLostFocus() {
        this.selected = false;
        this.component.setTextOverrun(OverrunStyle.ELLIPSIS);
        this.updateStyle();
    }

    @Override
    public void setWarning(boolean warning) {
        this.warning = warning;
        this.updateStyle();
    }

    public void handle(MouseEvent t) {
        this.getFocus();
    }

    private void updateStyle() {
        this.component.getStyleClass().remove((Object)"element-label-selected");
        this.component.getStyleClass().remove((Object)"element-label-error");
        if (this.selected) {
            this.component.getStyleClass().add((Object)"element-label-selected");
        }
        if (this.warning) {
            this.component.getStyleClass().add((Object)"element-label-error");
        }
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void update(Map<String, Object> data) {
        Object obj = data.get(this.field.getId());
        if (obj != null && obj instanceof InputElement) {
            InputElement ie = (InputElement)obj;
            if (ie.getOriginalValue() != null) {
                this.model.setValue(ie.getOriginalValue());
            } else {
                this.model.setValue(ie.getValue());
            }
            this.updateStyle();
        }
    }

    @Override
    public Control getControl() {
        return this.component;
    }
}

