/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.group;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import plfx.element.TitledArea;
import plfx.element.UpDownLable;
import plfx.input.keyboard.CommonKeyboardListener;
import plfx.input.keyboard.KeyboardListener;
import plfx.input.keyboard.letter.Layout;
import plfx.input.keyboard.letter.LetterKeyboard;
import plfx.model.action.ActionNotifier;
import plfx.model.textfield.InputFieldModel;
import plfx.screen.BaseCommonScreen;
import plfx.screen.FxScreenTemplate;
import plfx.screen.ScreenAdapter;
import plfx.screen.ScreenInit;
import plfx.screen.ScreenListener;
import plfx.screen.ScreenListenerAdapter;
import plfx.screen.input.group.AutoCompleteInputComponent;
import plfx.screen.input.group.CheckBoxInputComponent;
import plfx.screen.input.group.CommonActionNotifier;
import plfx.screen.input.group.DateInputComponent;
import plfx.screen.input.group.GroupHelper;
import plfx.screen.input.group.GroupTemplate;
import plfx.screen.input.group.InputComponent;
import plfx.screen.input.group.InputComponentListener;
import plfx.screen.input.group.NumericInputComponent;
import plfx.screen.input.group.RotateKeyboardListener;
import plfx.screen.input.group.SelectorInputComponent;
import plfx.screen.input.group.TextInputComponent;
import plfx.screen.pay.ButtonActionListener;
import ru.softlogic.input.model.field.Field;
import ru.softlogic.input.model.field.FieldType;
import ru.softlogic.input.model.field.IdentityField;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.autocomplete.AutoCompleteField;
import ru.softlogic.input.model.field.checkbox.CheckBoxField;
import ru.softlogic.input.model.field.date.DateField;
import ru.softlogic.input.model.field.numeric.NumericField;
import ru.softlogic.input.model.field.selector.SelectorField;
import ru.softlogic.input.model.field.text.Keyboard;
import ru.softlogic.input.model.field.text.TextField;
import ru.softlogic.input.model.screen.ActionType;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.input.model.screen.description.UniScreenDescription;

public class GroupScreen
extends BaseCommonScreen {
    private GroupTemplate tpl;
    protected List<InputComponent> components;
    private ScreenListener listener;
    protected LetterKeyboard letterKeyboard;
    protected CommonKeyboardListener keyboardListener;
    protected CommonActionNotifier notifier;
    protected List<IdentityField> fields;
    protected boolean skipPopup;

    public GroupScreen(GroupTemplate tpl, Map<String, Layout> layouts) {
        if (tpl == null) {
            throw new NullPointerException("GroupTemplate");
        }
        this.tpl = tpl;
        this.notifier = new CommonActionNotifier(this);
        tpl.getBackButton().setListener(new ButtonActionListener("prev", this.notifier));
        tpl.getExitButton().setListener(new ButtonActionListener("exit", this.notifier));
        tpl.getNextButton().setListener(new ButtonActionListener("next", this.notifier));
        tpl.getActions().forEach((a, b) -> b.setListener(() -> this.notifier.notify((String)a)));
        this.keyboardListener = new RotateKeyboardListener();
        this.letterKeyboard = tpl.getLetterKeyboard();
        if (this.letterKeyboard != null) {
            this.letterKeyboard.setLayouts(layouts);
            this.letterKeyboard.setKeyboardListener(this.keyboardListener);
        }
    }

    @Override
    protected void _init(ScreenDescription sd, ScreenInit si) throws InitException {
        if (!sd.getType().contains("letter") && !sd.getType().contains("group")) {
            throw new InitException("Wrong screen type, have " + sd.getType() + ", must be group or letter");
        }
        this.tpl.initButtons(sd.getButtons());
        if (sd.getSequence() == null || sd.getSequence().getFields() == null || sd.getSequence().getFields().isEmpty()) {
            throw new InitException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u044b \u043f\u043e\u043b\u044f");
        }
        if (sd.getSequence().getFields().size() > this.tpl.getTitledAreas().size()) {
            throw new InitException("Too many fields, count=" + sd.getSequence().getFields().size() + ", capacity=" + this.tpl.getTitledAreas().size());
        }
        String focusedField = null;
        if (sd instanceof UniScreenDescription) {
            UniScreenDescription usd = (UniScreenDescription)sd;
            focusedField = usd.getFocusedField();
        }
        for (TitledArea ta : this.tpl.getTitledAreas()) {
            ta.setVisible(false);
        }
        this.components = new LinkedList<InputComponent>();
        InputComponent focusedComp = null;
        Map d = si.getModelEnvironment().getData();
        this.fields = sd.getSequence().initFields(si.getModelEnvironment());
        int i = 0;
        for (Field field : this.fields) {
            if (field.isExist() && !d.containsKey(field.getId())) continue;
            TitledArea ta = this.tpl.getTitledAreas().get(i);
            ta.setVisible(true);
            InputComponent component = null;
            Object value = d.get(field.getId());
            if (field.getType() == FieldType.Letter) {
                component = this.createField((TextField)field, ta, value, (InputComponentListener)new LocalFocusListener(), i);
            } else if (field.getType() == FieldType.Numeric) {
                component = this.createField((NumericField)field, ta, value, (InputComponentListener)new LocalFocusListener(), i);
            } else if (field.getType() == FieldType.Selector) {
                component = this.createField((SelectorField)field, ta, value, (InputComponentListener)new LocalFocusListener(), i);
            } else if (field.getType() == FieldType.Date) {
                component = this.createField((DateField)field, ta, value, (InputComponentListener)new LocalFocusListener(), i);
            } else if (field.getType() == FieldType.AutoComplete) {
                component = this.createField((AutoCompleteField)field, ta, value, (InputComponentListener)new LocalFocusListener(), i);
            } else if (field.getType() == FieldType.CheckBox) {
                component = this.createField((CheckBoxField)field, ta, value, (InputComponentListener)new LocalFocusListener(), i);
            }
            this.components.add(component);
            if (field.getId().equals(focusedField)) {
                focusedComp = component;
            }
            ++i;
        }
        this.keyboardListener.setComponents(this.components);
        this.notifier.init();
        this.notifier.setComponents(this.components);
        this.skipPopup = true;
        if (!this.components.isEmpty()) {
            if (focusedComp != null) {
                focusedComp.getFocus();
            } else {
                this.components.get(0).getFocus();
            }
            this.processNext();
        }
        this.tpl.setServiceLogo(sd.getIcon(), sd.getStyleClass());
        if (this.tpl.getNavigation() != null) {
            this.tpl.getNavigation().init(sd.getNavigations(), this.notifier);
        }
    }

    @Override
    public void setListener(ScreenListener listener) {
        this.notifier.setListener(listener);
        this.tpl.setListener(new ScreenListenerAdapter(listener));
        this.listener = listener;
    }

    @Override
    public KeyboardListener getKeyboardListener() {
        return this.keyboardListener;
    }

    @Override
    protected ActionNotifier getActionNotifier() {
        return this.notifier;
    }

    protected void processNext() {
        boolean res = true;
        if (this.components != null) {
            for (InputComponent c : this.components) {
                res &= c.isValid();
            }
            this.tpl.getNextButton().setDisable(!res);
        }
    }

    @Override
    public FxScreenTemplate getTemplate() {
        return this.tpl;
    }

    protected InputComponent createField(TextField field, TitledArea ta, Object value, InputComponentListener l, int i) {
        Label label = new Label();
        ta.setControl((Control)label);
        ta.setTitle(field.getTitle() + ":");
        return new TextInputComponent(label, field, value, l, i);
    }

    protected InputComponent createField(NumericField field, TitledArea ta, Object value, InputComponentListener l, int i) {
        UpDownLable udl = new UpDownLable(Math.abs(field.getUpdown()) > 0.01);
        ta.setControl(udl);
        ta.setTitle(field.getTitle() + ":");
        return new NumericInputComponent(udl, field, value, l, i);
    }

    protected InputComponent createField(SelectorField field, TitledArea ta, Object value, InputComponentListener l, int i) {
        ComboBox cb = new ComboBox();
        ta.setControl((Control)cb);
        ta.setTitle(field.getTitle() + ":");
        return new SelectorInputComponent((ComboBox<String>)cb, field, value, l, i);
    }

    protected InputComponent createField(DateField field, TitledArea ta, Object value, InputComponentListener l, int i) {
        Label label = new Label();
        ta.setControl((Control)label);
        ta.setTitle(field.getTitle() + ":");
        return new DateInputComponent(label, field, value, l, i);
    }

    protected InputComponent createField(AutoCompleteField field, TitledArea ta, Object value, InputComponentListener l, int i) {
        Label label = new Label();
        ta.setControl((Control)label);
        ta.setTitle(field.getTitle() + ":");
        return new AutoCompleteInputComponent(label, field, value, l, i, this.listener);
    }

    protected InputComponent createField(CheckBoxField field, TitledArea ta, Object value, InputComponentListener l, int i) {
        Label label = new Label();
        ta.setControl((Control)label);
        ta.setTitle(field.getTitle() + ":");
        return new CheckBoxInputComponent(label, field, value, l, i);
    }

    protected InputComponentListener createFL() {
        return new LocalFocusListener();
    }

    private class OnTopListener
    extends ScreenAdapter {
        private final InputComponent component;

        public OnTopListener(InputComponent component) {
            this.component = component;
        }

        @Override
        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            if (ActionType.isNext((String)action)) {
                this.component.update(data);
                Optional.ofNullable(GroupScreen.this.listener).ifPresent(l -> l.setFieldPage(0, GroupScreen.this.components.size()));
            }
        }
    }

    private class LocalFocusListener
    implements InputComponentListener {
        private LocalFocusListener() {
        }

        @Override
        public void onSelect(InputComponent component, InputFieldModel model, Object init) {
            Keyboard keyboard = null;
            if (init instanceof Keyboard) {
                keyboard = (Keyboard)init;
            }
            GroupScreen.this.keyboardListener.setActiveComponent(component);
            for (InputComponent c : GroupScreen.this.components) {
                if (c == component) continue;
                c.onLostFocus();
            }
            GroupScreen.this.keyboardListener.setModel(model);
            if (GroupScreen.this.listener != null) {
                GroupScreen.this.listener.onSelectField(component.getIndex());
            }
            if (keyboard != null && GroupScreen.this.letterKeyboard != null) {
                GroupScreen.this.letterKeyboard.init(keyboard);
            }
            if (!GroupScreen.this.skipPopup) {
                IdentityField idf = GroupScreen.this.fields.get(component.getIndex());
                if (idf.getOnTop() != null && !idf.getOnTop().isEmpty() && GroupScreen.this.listener != null && !GroupScreen.this.fields.isEmpty()) {
                    LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
                    for (InputComponent ic : GroupScreen.this.components) {
                        ic.putData(data);
                    }
                    GroupScreen.this.listener.setFieldPage(0, 1);
                    GroupHelper.showPopup(idf, data, GroupScreen.this.listener, new OnTopListener(component));
                }
            } else {
                GroupScreen.this.skipPopup = false;
            }
        }

        @Override
        public void onChange() {
            GroupScreen.this.processNext();
        }

        @Override
        public void notifyUpdate() {
            GroupScreen.this.listener.notifyUpdate();
        }
    }
}

