/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.group;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import plfx.element.TitledArea;
import plfx.input.keyboard.KeyboardListener;
import plfx.input.keyboard.letter.Layout;
import plfx.input.keyboard.letter.LetterKeyboard;
import plfx.model.action.ActionNotifier;
import plfx.model.textfield.InputFieldModel;
import plfx.screen.BaseCommonScreen;
import plfx.screen.FxScreenTemplate;
import plfx.screen.ScreenInit;
import plfx.screen.ScreenListener;
import plfx.screen.ScreenListenerAdapter;
import plfx.screen.input.group.CommonActionNotifier;
import plfx.screen.input.group.GroupTemplate;
import plfx.screen.input.group.InputComponent;
import plfx.screen.input.group.InputComponentListener;
import plfx.screen.input.group.MetterComponent;
import plfx.screen.input.group.RotateKeyboardListener;
import plfx.screen.pay.ButtonActionListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.Field;
import ru.softlogic.input.model.field.IdentityField;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.numeric.NumericField;
import ru.softlogic.input.model.field.text.Keyboard;
import ru.softlogic.input.model.screen.description.ScreenDescription;

class GroupMeterScreen
extends BaseCommonScreen {
    private final GroupTemplate tpl;
    private final LetterKeyboard letterKeyboard;
    private final RotateKeyboardListener keyboardListener;
    private List<InputComponent> components;
    private ScreenListener listener;
    private CommonActionNotifier notifier;
    private Map<String, IdentityField> fields;
    private MetterComponent currComponent;
    private MetterComponent prevComponent;
    private MetterComponent consumptComponent;
    private MetterComponent tarifComponent;
    private MetterComponent sumComponent;

    public GroupMeterScreen(GroupTemplate tpl, Map<String, Layout> layouts) {
        this.tpl = Objects.requireNonNull(tpl, "GroupTemplate");
        this.notifier = new CommonActionNotifier(this);
        tpl.getBackButton().setListener(new ButtonActionListener("prev", this.notifier));
        tpl.getExitButton().setListener(new ButtonActionListener("exit", this.notifier));
        tpl.getNextButton().setListener(new ButtonActionListener("next", this.notifier));
        tpl.getActions().forEach((a, b) -> b.setListener(() -> this.notifier.notify((String)a)));
        this.keyboardListener = new RotateKeyboardListener();
        this.letterKeyboard = tpl.getLetterKeyboard();
        if (this.letterKeyboard != null) {
            this.letterKeyboard.setLayouts(layouts);
            this.letterKeyboard.setKeyboardListener(this.keyboardListener);
        }
    }

    @Override
    protected void _init(ScreenDescription sd, ScreenInit si) throws InitException {
        if (sd.getType() == null || sd.getType().isEmpty()) {
            throw new InitException("Wrong screen type, have " + sd.getType() + ", must be group or letter");
        }
        if (!sd.getType().startsWith("letter") && !sd.getType().startsWith("group")) {
            throw new InitException("Wrong screen type, have " + sd.getType() + ", must be group or letter");
        }
        this.tpl.initButtons(sd.getButtons());
        if (sd.getSequence() == null || sd.getSequence().getFields() == null || sd.getSequence().getFields().isEmpty()) {
            throw new InitException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u044b \u043f\u043e\u043b\u044f");
        }
        Map d = si.getModelEnvironment().getData();
        this.fields = sd.getSequence().initFields(si.getModelEnvironment()).stream().filter(f -> !f.isExist() || d.containsKey(f.getId())).sorted((f1, f2) -> f1.getGroupId() - f2.getGroupId()).collect(Collectors.toMap(Field::getId, Function.identity()));
        List<TitledArea> titledAreas = this.tpl.getTitledAreas();
        titledAreas.stream().forEach(ta -> ta.setVisible(false));
        this.components = new LinkedList<InputComponent>();
        TitledArea ta2 = null;
        Label udl = null;
        int focus = 0;
        NumericField current = (NumericField)this.fields.get("current");
        Label curr = new Label();
        this.currComponent = new MetterComponent(curr, current, d.get(current.getId()), new LocalFocusListeer(), 0);
        ta2 = titledAreas.get(0);
        ta2.setVisible(true);
        ta2.setGroup(current.getGroupId());
        ta2.setControl((Control)curr);
        ta2.setTitle(current.getTitle());
        this.components.add(this.currComponent);
        NumericField previous = (NumericField)this.fields.get("previous");
        udl = new Label();
        udl.setDisable(true);
        this.prevComponent = new MetterComponent(udl, previous, d.get(previous.getId()), new LocalFocusListeer(), 1);
        String v = ((InputElement)d.get(previous.getId())).getValue();
        if (v == null || v.isEmpty()) {
            focus = 2;
            curr.setDisable(true);
        } else {
            this.currComponent.setStandard(this.prevComponent.getValue());
        }
        ta2 = titledAreas.get(1);
        ta2.setVisible(true);
        ta2.setGroup(previous.getGroupId());
        ta2.setControl((Control)udl);
        ta2.setTitle(previous.getTitle());
        this.components.add(this.prevComponent);
        NumericField consumption = (NumericField)this.fields.get("consumption");
        udl = new Label();
        this.consumptComponent = new MetterComponent(udl, consumption, d.get(consumption.getId()), new LocalFocusListeer(), 2);
        ta2 = titledAreas.get(2);
        ta2.setVisible(true);
        ta2.setGroup(consumption.getGroupId());
        ta2.setControl((Control)udl);
        ta2.setTitle(consumption.getTitle());
        this.components.add(this.consumptComponent);
        NumericField tariff = (NumericField)this.fields.get("tariff");
        udl = new Label();
        udl.setDisable(true);
        this.tarifComponent = new MetterComponent(udl, tariff, d.get(tariff.getId()), new LocalFocusListeer(), 3);
        ta2 = titledAreas.get(3);
        ta2.setVisible(true);
        ta2.setGroup(tariff.getGroupId());
        ta2.setControl((Control)udl);
        ta2.setTitle(tariff.getTitle());
        this.components.add(this.tarifComponent);
        NumericField summ = (NumericField)this.fields.get("summ");
        udl = new Label();
        udl.setDisable(true);
        this.sumComponent = new MetterComponent(udl, summ, d.get(summ.getId()), new LocalFocusListeer(), 4);
        ta2 = titledAreas.get(4);
        ta2.setVisible(true);
        ta2.setGroup(summ.getGroupId());
        ta2.setControl((Control)udl);
        ta2.setTitle(summ.getTitle());
        this.components.add(this.sumComponent);
        this.components.forEach(c -> c.update(d));
        this.notifier.init();
        this.notifier.setComponents(this.components);
        this.components.get(focus).getFocus();
        this.processNext();
        this.tpl.setServiceLogo(sd.getIcon(), sd.getStyleClass());
        if (this.tpl.getNavigation() != null) {
            this.tpl.getNavigation().init(sd.getNavigations(), this.notifier);
        }
    }

    @Override
    public void setListener(ScreenListener listener) {
        this.notifier.setListener(listener);
        this.tpl.setListener(new ScreenListenerAdapter(listener));
        this.listener = listener;
    }

    @Override
    public KeyboardListener getKeyboardListener() {
        return this.keyboardListener;
    }

    @Override
    protected ActionNotifier getActionNotifier() {
        return this.notifier;
    }

    private void processNext() {
        if (this.prevComponent != null && this.prevComponent.getValue() != null && this.currComponent != null) {
            this.tpl.getNextButton().setDisable(!this.currComponent.isValid());
        } else {
            this.tpl.getNextButton().setDisable(false);
        }
    }

    @Override
    public FxScreenTemplate getTemplate() {
        return this.tpl;
    }

    private class LocalFocusListeer
    implements InputComponentListener {
        private MetterComponent focused;

        private LocalFocusListeer() {
        }

        @Override
        public void onSelect(InputComponent component, InputFieldModel model, Object init) {
            GroupMeterScreen.this.components.stream().filter(c -> c != component).forEach(c -> c.onLostFocus());
            Keyboard keyboard = (Keyboard)init;
            GroupMeterScreen.this.keyboardListener.setActiveComponent(component);
            GroupMeterScreen.this.keyboardListener.setModel(model);
            if (GroupMeterScreen.this.listener != null) {
                GroupMeterScreen.this.listener.onSelectField(component.getIndex());
            }
            GroupMeterScreen.this.letterKeyboard.init(keyboard);
            if (component instanceof MetterComponent) {
                this.focused = (MetterComponent)component;
            }
        }

        @Override
        public void onChange() {
            if (this.focused != null) {
                String id = this.focused.getId();
                Double value = this.focused.getValue();
                if ("consumption".equals(id)) {
                    if (value == null) {
                        GroupMeterScreen.this.sumComponent.setValue(0.0);
                        GroupMeterScreen.this.currComponent.setValue(null);
                    } else {
                        GroupMeterScreen.this.sumComponent.setValue(GroupMeterScreen.this.tarifComponent.getValue() * value);
                        if (GroupMeterScreen.this.prevComponent.getValue() != null) {
                            GroupMeterScreen.this.currComponent.setValue(GroupMeterScreen.this.prevComponent.getValue() + value);
                        }
                    }
                } else if ("current".equals(id)) {
                    if (value == null) {
                        GroupMeterScreen.this.consumptComponent.setValue(null);
                        GroupMeterScreen.this.sumComponent.setValue(0.0);
                    } else {
                        double consump = value - GroupMeterScreen.this.prevComponent.getValue();
                        if (consump < 0.0) {
                            GroupMeterScreen.this.consumptComponent.setValue(null);
                            GroupMeterScreen.this.sumComponent.setValue(0.0);
                        } else {
                            GroupMeterScreen.this.consumptComponent.setValue(consump);
                            GroupMeterScreen.this.sumComponent.setValue(GroupMeterScreen.this.tarifComponent.getValue() * GroupMeterScreen.this.consumptComponent.getValue());
                        }
                    }
                }
            }
            GroupMeterScreen.this.processNext();
        }

        @Override
        public void notifyUpdate() {
            GroupMeterScreen.this.listener.notifyUpdate();
        }
    }
}

