/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.group;

import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Properties;
import plfx.GuiNotifier;
import plfx.element.FxInitException;
import plfx.input.keyboard.letter.Layout;
import plfx.input.keyboard.letter.LayoutLoader;
import plfx.screen.CommonScreen;
import plfx.screen.CommonScreenFactory;
import plfx.screen.ScreenCreateException;
import plfx.screen.input.group.DefaultGroupTemplate;
import plfx.screen.input.group.GroupScreen;
import plfx.screen.input.group.GroupTemplate;
import plfx.util.LoadTemplateException;
import plfx.util.Locator;
import plfx.util.ResourceLoader;

public class DefaultGroupFactory
implements CommonScreenFactory {
    @Override
    public CommonScreen create(String path, Properties prop) throws ScreenCreateException {
        try {
            Map<String, Layout> layouts;
            try {
                layouts = LayoutLoader.readLayouts("/screen/pay/" + path + "/layout.properties", prop);
            }
            catch (FxInitException ex) {
                layouts = LayoutLoader.readLayouts("/layout/default.properties", prop);
            }
            GroupTemplate template = null;
            String controller = prop.getProperty("controller", "");
            if (!controller.isEmpty()) {
                try {
                    Constructor<?> c = Class.forName(controller).getConstructor(String.class, String.class);
                    template = (GroupTemplate)c.newInstance("screen.pay." + path, path.startsWith("@") ? "ext" : "skin");
                }
                catch (Throwable throwable) {
                    GuiNotifier.notifyError(throwable);
                    template = new DefaultGroupTemplate("screen.pay." + path, path.startsWith("@") ? "ext" : "skin");
                }
            } else {
                template = new DefaultGroupTemplate("screen.pay." + path, path.startsWith("@") ? "ext" : "skin");
            }
            if (path.startsWith("@")) {
                ResourceLoader.load(Locator.getUrl("/gui/system/screen/" + path.substring(1) + "/template.fxml"), template);
            } else {
                ResourceLoader.load(Locator.getFileUrl("/gui/skin/{name}//screen/pay/" + path + "/template.fxml"), template);
            }
            template.init();
            CommonScreen screen = null;
            String screenName = prop.getProperty("screen", "");
            if (!screenName.isEmpty()) {
                try {
                    Constructor<?> c = Class.forName(screenName).getConstructor(GroupTemplate.class, Map.class);
                    screen = (CommonScreen)c.newInstance(template, layouts);
                }
                catch (Throwable throwable) {
                    GuiNotifier.notifyError(throwable);
                    screen = new GroupScreen(template, layouts);
                }
            } else {
                screen = new GroupScreen(template, layouts);
            }
            return screen;
        }
        catch (FxInitException | LoadTemplateException ex) {
            GuiNotifier.notifyError(ex);
            throw new ScreenCreateException("Erron on create group screen: " + path, ex);
        }
    }
}

