/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.group;

import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import javafx.event.EventHandler;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.OverrunStyle;
import javafx.scene.input.MouseEvent;
import plfx.screen.input.group.InputComponent;
import plfx.screen.input.group.InputComponentListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.date.DateField;

public class DateInputComponent
implements InputComponent,
EventHandler<MouseEvent> {
    protected DateField field;
    protected Label component;
    protected InputComponentListener listener;
    protected boolean selected;
    protected boolean warning;
    protected boolean valid;
    protected int index;
    private Date selectDate;

    public DateInputComponent(Label component, DateField field, Object oValue, InputComponentListener listener, int index) {
        this.field = field;
        this.listener = listener;
        this.component = component;
        this.index = index;
        component.getStyleClass().add((Object)"element-label");
        component.getStyleClass().add((Object)"label");
        component.setOnMousePressed((EventHandler)this);
        component.setText(field.getFormaterTitle().format(field.getValue()));
        this.selectDate = field.getValue();
        if (field.getOnTop() == null || field.getOnTop().isEmpty()) {
            field.setOnTop("date/popup");
        }
        this.updateStyle();
    }

    @Override
    public boolean isValid() {
        this.valid = this.selectDate != null;
        return this.valid;
    }

    @Override
    public void putData(Map<String, Object> data) {
        if (this.selectDate != null) {
            data.put(this.field.getId(), new InputElement(this.field.getId(), this.field.getTitle(), this.field.getTitleId(), this.field.getFormater().format(this.selectDate), this.field.getFormaterTitle().format(this.selectDate), this.field.getFlags()));
        }
    }

    public String toString() {
        return "DateInputComponent1{field=" + this.field + '}';
    }

    @Override
    public void getFocus() {
        this.selected = true;
        this.component.setTextOverrun(OverrunStyle.LEADING_ELLIPSIS);
        this.listener.onSelect(this, null, null);
        this.updateStyle();
    }

    @Override
    public void onLostFocus() {
        this.selected = false;
        this.component.setTextOverrun(OverrunStyle.LEADING_ELLIPSIS);
        this.updateStyle();
    }

    @Override
    public void setWarning(boolean warning) {
        this.warning = warning;
        this.updateStyle();
    }

    private void updateStyle() {
        this.component.getStyleClass().remove((Object)"element-label-selected");
        this.component.getStyleClass().remove((Object)"element-label-error");
        if (this.selected) {
            this.component.getStyleClass().add((Object)"element-label-selected");
        }
        if (this.warning) {
            this.component.getStyleClass().add((Object)"element-label-error");
        }
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void update(Map<String, Object> data) {
        Object obj = data.get(this.field.getId());
        if (obj != null && obj instanceof InputElement) {
            InputElement ie = (InputElement)obj;
            if (ie.getValue() != null && !ie.getValue().isEmpty()) {
                try {
                    this.selectDate = this.field.getFormater().parse(ie.getValue());
                    this.component.setText(this.field.getFormaterTitle().format(this.selectDate));
                    this.listener.onChange();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            this.updateStyle();
        }
    }

    public void handle(MouseEvent t) {
        this.getFocus();
    }

    @Override
    public Control getControl() {
        return this.component;
    }
}

