/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.group;

import java.util.Map;
import javafx.event.EventHandler;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.input.MouseEvent;
import plfx.msg.LabeledMessageTemplate;
import plfx.msg.screen.ScreenProcessor;
import plfx.screen.input.group.InputComponent;
import plfx.screen.input.group.InputComponentListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.checkbox.CheckBoxField;

public class CheckBoxInputComponent
implements InputComponent,
EventHandler<MouseEvent> {
    protected CheckBoxField field;
    protected Label component;
    protected InputComponentListener listener;
    protected boolean selected;
    protected boolean warning;
    protected boolean checked;
    protected int index;
    protected String fieldMessage;
    protected String fieldMessageId;
    protected String fieldHelpId;
    protected String fieldHelp;

    public CheckBoxInputComponent(Label component, CheckBoxField field, Object oValue, InputComponentListener listener, int index) {
        InputElement ie;
        this.field = field;
        this.fieldMessage = field.getMessage();
        this.fieldMessageId = field.getMessageId();
        this.fieldHelp = field.getHelp();
        this.fieldHelpId = field.getHelpId();
        this.component = component;
        this.listener = listener;
        this.index = index;
        component.getStyleClass().add((Object)"element-checkbox");
        component.getStyleClass().add((Object)"checkbox");
        component.setOnMousePressed((EventHandler)this);
        this.checked = oValue instanceof InputElement ? ((ie = (InputElement)oValue).getOriginalValue() != null ? Boolean.parseBoolean(ie.getOriginalValue()) : Boolean.parseBoolean(ie.getValue())) : Boolean.parseBoolean(field.getValue());
        this.process();
        this.updateStyle();
    }

    @Override
    public boolean isValid() {
        boolean valid = !this.field.isRequired() || this.checked;
        this.setWarning(!valid);
        return valid;
    }

    @Override
    public void putData(Map<String, Object> data) {
        String ch = Boolean.toString(this.checked);
        InputElement ie = new InputElement(this.field.getId(), this.field.getTitle(), this.field.getTitleId(), ch, ch, this.field.getFlags());
        data.put(this.field.getId(), ie);
    }

    @Override
    public void getFocus() {
        this.selected = true;
        this.listener.onSelect(this, null, null);
        this.updateStyle();
    }

    @Override
    public void onLostFocus() {
        this.selected = false;
        this.updateStyle();
    }

    @Override
    public void setWarning(boolean warning) {
        this.warning = warning;
        this.updateStyle();
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void update(Map<String, Object> data) {
        Object obj = data.get(this.field.getId());
        if (obj != null && obj instanceof InputElement) {
            InputElement ie = (InputElement)obj;
            this.checked = ie.getOriginalValue() != null ? Boolean.parseBoolean(ie.getOriginalValue()) : Boolean.parseBoolean(ie.getValue());
            this.updateStyle();
        }
    }

    @Override
    public Control getControl() {
        return this.component;
    }

    public void handle(MouseEvent event) {
        if (!this.field.isReadOnly()) {
            this.checked = !this.checked;
            this.process();
            this.listener.onChange();
            this.listener.notifyUpdate();
            this.getFocus();
        }
    }

    private void updateStyle() {
        this.component.getStyleClass().remove((Object)"element-checkbox-selected");
        this.component.getStyleClass().remove((Object)"element-checkbox-error");
        this.component.getStyleClass().remove((Object)"element-checkbox-checked");
        this.component.getStyleClass().remove((Object)"element-checkbox-unchecked");
        this.component.getStyleClass().remove((Object)"element-checkbox-checked-readonly");
        this.component.getStyleClass().remove((Object)"element-checkbox-unchecked-readonly");
        if (this.selected) {
            this.component.getStyleClass().add((Object)"element-checkbox-selected");
        }
        if (this.warning) {
            this.component.getStyleClass().add((Object)"element-checkbox-error");
        }
        if (this.checked) {
            this.component.getStyleClass().add((Object)("element-checkbox-checked" + (this.field.isReadOnly() ? "-readonly" : "")));
        } else {
            this.component.getStyleClass().add((Object)("element-checkbox-unchecked" + (this.field.isReadOnly() ? "-readonly" : "")));
        }
    }

    private void process() {
        if (this.checked) {
            this.field.setMessage(this.fieldMessage);
            this.field.setMessageId(this.fieldMessageId);
            this.field.setHelp(this.fieldHelp);
            this.field.setHelp(this.field.getHelp());
            this.field.setHelpId(this.fieldHelpId);
        } else {
            if (this.field.getMessageOff() != null && !this.field.getMessageOff().isEmpty()) {
                this.field.setMessage(this.field.getMessageOff());
            }
            if (this.field.getMessageOffId() != null && !this.field.getMessageOffId().isEmpty()) {
                this.field.setMessageId(this.field.getMessageOffId());
            }
            if (this.field.getHelpOff() != null && !this.field.getHelpOff().isEmpty()) {
                this.field.setHelpSoftwareTypeMap(this.field.getHelpOff());
            }
            if (this.field.getHelpOffId() != null && !this.field.getHelpOffId().isEmpty()) {
                this.field.setHelpId(this.field.getHelpOffId());
            }
        }
        LabeledMessageTemplate lmt = new LabeledMessageTemplate((Labeled)this.component, this.field.getText() == null ? "" : this.field.getText());
        ScreenProcessor.process("skin", lmt);
    }
}

