/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.group;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.OverrunStyle;
import javafx.scene.input.MouseEvent;
import javafx.stage.Popup;
import javafx.stage.Window;
import plfx.model.textfield.FieldListener;
import plfx.model.textfield.InputFieldModel;
import plfx.screen.ScreenListener;
import plfx.screen.input.group.InputComponent;
import plfx.screen.input.group.InputComponentListener;
import plfx.skin.Skin;
import plfx.util.Locator;
import plfx.util.TerminalPlatform;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.autocomplete.AutoCompleteField;

public class AutoCompleteInputComponent
implements InputComponent,
EventHandler<MouseEvent> {
    protected AutoCompleteField field;
    protected Label component;
    protected InputFieldModel model;
    protected InputComponentListener listener;
    protected boolean selected;
    protected boolean warning;
    protected boolean valid;
    protected int index;
    protected InputElement complete;
    protected boolean completed;
    private final AutoCompletePopup autoCompletePopup;

    public AutoCompleteInputComponent(Label component, final AutoCompleteField field, Object oValue, InputComponentListener listener, int index, ScreenListener parentListener) {
        this.field = field;
        this.listener = listener;
        this.component = component;
        this.index = index;
        component.getStyleClass().add((Object)"element-label");
        component.getStyleClass().add((Object)"label");
        component.setOnMousePressed((EventHandler)this);
        this.autoCompletePopup = new AutoCompletePopup(component);
        this.model = new AutoCompleteModel();
        this.model.addListener(new FieldListener(){

            @Override
            public void onChange(String value) {
                if (AutoCompleteInputComponent.this.completed || field.isAllowCustom() && !value.isEmpty()) {
                    AutoCompleteInputComponent.this.completed = false;
                    AutoCompleteInputComponent.this.component.setText(value);
                    if (field.isAllowCustom()) {
                        AutoCompleteInputComponent.this.complete = new InputElement(field.getId(), field.getTitle(), value);
                        AutoCompleteInputComponent.this.listener.onChange();
                    }
                } else {
                    AutoCompleteInputComponent.this.complete = null;
                    AutoCompleteInputComponent.this.component.setText(value);
                    AutoCompleteInputComponent.this.listener.onChange();
                }
            }

            @Override
            public void onEnter(String value) {
            }
        });
        this.model.setValue("");
        if (oValue instanceof InputElement) {
            InputElement ie;
            this.complete = ie = (InputElement)oValue;
            this.completed = false;
            component.setText(ie.getValueTitle());
        } else {
            InputElement def = field.getDataStore().getDefaultElement();
            if (def != null) {
                this.complete = def;
                this.completed = false;
                component.setText(def.getValueTitle());
            }
        }
        component.textProperty().addListener((ChangeListener)new AutoCompleteListener());
        this.updateStyle();
    }

    @Override
    public boolean isValid() {
        this.valid = this.complete != null || this.model.getValue().isEmpty() && this.field.isOptional();
        this.setWarning(!this.model.getValue().isEmpty() && !this.valid && !this.selected);
        return this.valid;
    }

    @Override
    public void putData(Map<String, Object> data) {
        if (this.complete != null) {
            this.complete.setKey(this.field.getId());
            this.complete.setKeyTitle(this.field.getTitle());
            this.complete.setKeyTitleId(this.field.getTitleId());
            this.complete.setFlags(this.field.getFlags());
            data.put(this.field.getId(), this.complete);
        }
    }

    public String toString() {
        return "AutoCompleteInputComponent{field=" + this.field + '}';
    }

    @Override
    public void getFocus() {
        this.selected = true;
        this.component.setTextOverrun(OverrunStyle.LEADING_ELLIPSIS);
        this.listener.onSelect(this, this.model, this.field.getKeyboard());
        this.updateStyle();
    }

    @Override
    public void onLostFocus() {
        this.selected = false;
        this.component.setTextOverrun(OverrunStyle.ELLIPSIS);
        this.updateStyle();
    }

    @Override
    public void setWarning(boolean warning) {
        this.warning = warning;
        this.updateStyle();
    }

    public void handle(MouseEvent t) {
        this.getFocus();
    }

    private void updateStyle() {
        while (this.component.getStyleClass().remove((Object)"element-label-error")) {
        }
        while (this.component.getStyleClass().remove((Object)"element-label-selected")) {
        }
        if (this.selected) {
            this.component.getStyleClass().add((Object)"element-label-selected");
        }
        if (this.warning) {
            this.component.getStyleClass().add((Object)"element-label-error");
        }
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void update(Map<String, Object> data) {
        Object obj = data.get(this.field.getId());
        if (obj != null && obj instanceof InputElement) {
            InputElement ie = (InputElement)obj;
            this.model.setValue(ie.getOriginalValue());
            this.updateStyle();
        }
    }

    @Override
    public Control getControl() {
        return this.component;
    }

    private static class AutoCompleteModel
    implements InputFieldModel {
        private String value;
        private final Set<FieldListener> listeners = new HashSet<FieldListener>();

        @Override
        public void add(char ch) {
            this._add(ch, true);
        }

        @Override
        public void clear() {
            this.value = "";
            this.notifyListeners();
        }

        @Override
        public void clearLast() {
            this.value = this.value.length() > 0 ? this.value.substring(0, this.value.length() - 1) : "";
            this.notifyListeners();
        }

        @Override
        public void setValue(String value) {
            this.value = "";
            if (value != null && !value.isEmpty()) {
                for (char ch : value.toCharArray()) {
                    this._add(ch, false);
                }
                this.notifyListeners();
            }
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String getClearValue() {
            return this.value;
        }

        @Override
        public void addListener(FieldListener listener) {
            if (listener != null) {
                this.listeners.add(listener);
            }
        }

        private void notifyListeners() {
            for (FieldListener fl : this.listeners) {
                fl.onChange(this.getValue());
            }
        }

        private void _add(char ch, boolean doNotify) {
            this.value = this.value + Character.toString(ch);
            if (doNotify) {
                this.notifyListeners();
            }
        }

        @Override
        public void enter() {
            for (FieldListener fl : this.listeners) {
                fl.onEnter(this.getValue());
            }
        }
    }

    private class AutoCompletePopup {
        private Popup popup;
        private ListView<String> listView;
        private final Label label;
        private Thread timeout;
        private List<InputElement> list;

        public AutoCompletePopup(Label label) {
            this.label = label;
            this.popup = new Popup();
            this.popup.setAutoHide(true);
            this.popup.setConsumeAutoHidingEvents(false);
            this.listView = new ListView();
            this.listView.getStyleClass().add((Object)"autocomplete-popup");
            Optional.ofNullable(Locator.getFileUrl("/gui/skin/{name}/system/colorscheme.css")).ifPresent(css -> this.listView.getStylesheets().add((Object)css.toExternalForm()));
            Optional.ofNullable(Locator.getFileUrl("/gui/skin/{name}/system/" + Skin.getWorkScreenSizeName() + ".css")).ifPresent(css -> this.listView.getStylesheets().add((Object)css.toExternalForm()));
            this.popup.getContent().add(this.listView);
            this.listView.setOnMouseClicked(t -> {
                MultipleSelectionModel selection = this.listView.getSelectionModel();
                if (selection.getSelectedIndex() >= 0 && selection.getSelectedItem() != null && this.list != null) {
                    AutoCompleteInputComponent.this.complete = this.list.get(selection.getSelectedIndex());
                }
                if (AutoCompleteInputComponent.this.complete != null) {
                    AutoCompleteInputComponent.this.completed = true;
                    AutoCompleteInputComponent.this.model.setValue(AutoCompleteInputComponent.this.complete.getValueTitle());
                    AutoCompleteInputComponent.this.listener.onChange();
                    this.popup.hide();
                }
            });
        }

        public void show(List<InputElement> list) {
            this.list = list;
            this.popup.hide();
            if (this.timeout != null && this.timeout.isAlive()) {
                this.timeout.interrupt();
            }
            this.timeout = new Thread(() -> {
                try {
                    Thread.sleep(30000L);
                    TerminalPlatform.runLater(() -> this.popup.hide());
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            });
            this.listView.getItems().clear();
            list.stream().forEach(ie -> this.listView.getItems().add((Object)ie.getValueTitle()));
            this.listView.setPrefHeight(this.label.getHeight() * (double)list.size());
            this.listView.setPrefWidth(this.label.getWidth());
            this.timeout.start();
            if (this.label.getScene() != null) {
                Window w = this.label.getScene().getWindow();
                this.popup.show(w, w.getX() + this.label.localToScene(0.0, 0.0).getX() + this.label.getScene().getX(), w.getY() + this.label.localToScene(0.0, 0.0).getY() + this.label.getScene().getY() + this.label.getHeight());
            }
        }
    }

    private class AutoCompleteListener
    implements ChangeListener<String> {
        private AutoCompleteListener() {
        }

        public void changed(ObservableValue<? extends String> ov, String t, String value) {
            if (value != null && !value.isEmpty() && value.length() >= AutoCompleteInputComponent.this.field.getMinChars()) {
                List result = AutoCompleteInputComponent.this.field.getDataStore().getElements(value, AutoCompleteInputComponent.this.field.getMaxItems());
                if (AutoCompleteInputComponent.this.complete != null) {
                    result.remove(AutoCompleteInputComponent.this.complete);
                }
                if (!result.isEmpty() && result.size() <= AutoCompleteInputComponent.this.field.getMaxItems()) {
                    AutoCompleteInputComponent.this.autoCompletePopup.show(result);
                }
            }
        }
    }
}

