/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.date;

import java.util.Date;
import java.util.Locale;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Button;
import plfx.element.FxInitException;
import plfx.element.SLabel;
import plfx.screen.input.date.BaseDateTemplate;
import plfx.screen.input.date.CalendarComponent;
import plfx.screen.input.date.DateSButton;
import plfx.screen.input.date.DateTemplateListener;
import ru.softlogic.input.model.field.date.DateField;

public class DefaultDateTemplate
extends BaseDateTemplate
implements ChangeListener<Date> {
    private DateTemplateListener listener;
    private CalendarComponent calendarComponent;

    public DefaultDateTemplate(String screenId) {
        super(screenId);
    }

    @Override
    public void init() throws FxInitException {
        super.init();
        this.nextBtn.setDisable(true);
        this.nextBtn.setListener(() -> {
            if (this.listener != null) {
                this.listener.onSelect(this.calendarComponent.getSelectDate());
            }
        });
        DateSButton[][] days = new DateSButton[6][7];
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 7; ++j) {
                days[i][j] = new DateSButton((Button)this.searchNode("calendarDay" + i + j));
            }
        }
        Button prev = (Button)this.searchNode("calendarMonthPrev");
        Button next = (Button)this.searchNode("calendarMonthNext");
        SLabel monthYear = this.searchScreenLabel("calendarMonthYear", true);
        SLabel[] dw = new SLabel[7];
        for (int i = 0; i < 7; ++i) {
            dw[i] = this.searchScreenLabel("calendarWeek" + i, true);
        }
        this.calendarComponent = new CalendarComponent(prev, next, monthYear, days, dw, this.getDefaultBundle(), this);
    }

    @Override
    public void setDate(DateField dateField, DateTemplateListener listener) {
        this.listener = listener;
        this.calendarComponent.init(dateField.getFrom(), dateField.getTo(), dateField.getValue(), Locale.getDefault());
    }

    public void changed(ObservableValue<? extends Date> ov, Date t, Date t1) {
        this.nextBtn.setDisable(false);
    }
}

