/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.date;

import java.lang.reflect.Constructor;
import java.util.Properties;
import plfx.GuiNotifier;
import plfx.element.FxInitException;
import plfx.screen.CommonScreen;
import plfx.screen.CommonScreenFactory;
import plfx.screen.ScreenCreateException;
import plfx.screen.input.date.DateScreen;
import plfx.screen.input.date.DateTemplate;
import plfx.screen.input.date.DefaultDateTemplate;
import plfx.util.LoadTemplateException;
import plfx.util.Locator;
import plfx.util.ResourceLoader;

public class DefaultDateFactory
implements CommonScreenFactory {
    @Override
    public CommonScreen create(String path, Properties prop) throws ScreenCreateException {
        try {
            DateTemplate template = null;
            String controller = prop.getProperty("controller", "");
            if (!controller.isEmpty()) {
                try {
                    Constructor<?> c = Class.forName(controller).getConstructor(String.class);
                    template = (DateTemplate)c.newInstance("screen.pay." + path);
                }
                catch (Throwable throwable) {
                    GuiNotifier.notifyError(throwable);
                    template = new DefaultDateTemplate("screen.pay." + path);
                }
            } else {
                template = new DefaultDateTemplate("screen.pay." + path);
            }
            if (path.startsWith("@")) {
                ResourceLoader.load(Locator.getUrl("/gui/system/screen/" + path.substring(1) + "/template.fxml"), template);
            } else {
                ResourceLoader.load(Locator.getUrl("/gui/skin/{name}//screen/pay/" + path + "/template.fxml"), template);
            }
            template.init();
            CommonScreen screen = null;
            String screenName = prop.getProperty("screen", "");
            if (!screenName.isEmpty()) {
                try {
                    Constructor<?> c = Class.forName(screenName).getConstructor(DateTemplate.class);
                    screen = (CommonScreen)c.newInstance(template);
                }
                catch (Throwable throwable) {
                    GuiNotifier.notifyError(throwable);
                    screen = new DateScreen(template);
                }
            } else {
                screen = new DateScreen(template);
            }
            return screen;
        }
        catch (FxInitException | LoadTemplateException ex) {
            GuiNotifier.notifyError(ex);
            throw new ScreenCreateException("Erron on create info screen: " + path, ex);
        }
    }
}

