/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.date;

import java.util.Date;
import plfx.input.keyboard.KeyboardListener;
import plfx.model.action.ActionNotifier;
import plfx.screen.BaseCommonScreen;
import plfx.screen.FxScreenTemplate;
import plfx.screen.ScreenInit;
import plfx.screen.ScreenListener;
import plfx.screen.input.date.DateActionListener;
import plfx.screen.input.date.DateActionNotifier;
import plfx.screen.input.date.DateTemplate;
import plfx.screen.input.date.DateTemplateListener;
import ru.softlogic.input.model.field.Field;
import ru.softlogic.input.model.field.FieldType;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.date.DateField;
import ru.softlogic.input.model.screen.description.ScreenDescription;

public class DateScreen
extends BaseCommonScreen {
    private DateTemplate tpl;
    private DateActionNotifier notifier;

    public DateScreen(DateTemplate tpl) {
        if (tpl == null) {
            throw new NullPointerException("DateTemplate");
        }
        this.tpl = tpl;
        this.notifier = new DateActionNotifier(this);
        tpl.getBackButton().setListener(new DateActionListener("prev", this.notifier));
        tpl.getExitButton().setListener(new DateActionListener("exit", this.notifier));
        tpl.getActions().forEach((a, b) -> b.setListener(() -> this.notifier.notify((String)a)));
    }

    @Override
    protected void _init(ScreenDescription sd, ScreenInit si) throws InitException {
        if (sd.getSequence().getFields() == null || sd.getSequence().getFields().size() != 1) {
            throw new InitException("Screen must have one field");
        }
        this.tpl.initButtons(sd.getButtons());
        Field field = (Field)sd.getSequence().initFields(si.getModelEnvironment()).get(0);
        if (field.getType() != FieldType.Date) {
            throw new InitException("Field has wrong type");
        }
        DateField df = (DateField)sd.getSequence().getFields().get(0);
        this.tpl.setDate(df, new LocalTemplateListener());
        this.notifier.init();
        this.notifier.setField(df);
        this.tpl.setServiceLogo(sd.getIcon(), sd.getStyleClass());
        if (this.tpl.getNavigation() != null) {
            this.tpl.getNavigation().init(sd.getNavigations(), this.notifier);
        }
    }

    @Override
    public void setListener(ScreenListener listener) {
        this.notifier.setListener(listener);
    }

    @Override
    public KeyboardListener getKeyboardListener() {
        return null;
    }

    @Override
    public FxScreenTemplate getTemplate() {
        return this.tpl;
    }

    @Override
    protected ActionNotifier getActionNotifier() {
        return this.notifier;
    }

    private class LocalTemplateListener
    implements DateTemplateListener {
        private LocalTemplateListener() {
        }

        @Override
        public void onSelect(Date date) {
            DateScreen.this.notifier.setSelectDatem(date);
            DateScreen.this.notifier.notify("next");
        }
    }
}

