/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.confirm;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.VBox;
import plfx.element.FxInitException;
import plfx.msg.LabeledMessageTemplate;
import plfx.msg.ScreenElement;
import plfx.msg.SupplierMessageTemplate;
import plfx.screen.input.communal.CommunalHelper;
import plfx.screen.input.confirm.ConfirmCommunalTemplate;
import plfx.screen.pay.InputTemplateImpl;
import plfx.util.Cache;
import plfx.util.Locator;
import plfx.util.ResourceLoader;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;

public class UniConfirmCommunalTemplate
extends InputTemplateImpl
implements ConfirmCommunalTemplate {
    @FXML
    private ScrollPane communalList;
    @FXML
    private VBox communalItems;
    private final ConfirmItemCache confirmItemCache = new ConfirmItemCache(4);

    public UniConfirmCommunalTemplate(String screenId) {
        super(screenId, "skin");
    }

    @Override
    public void setConfirmed(List<InputElement> elements, List<Data> services) {
        int i2;
        this.getDynamicElements().clear();
        this.communalItems.getChildren().clear();
        if (elements != null && !elements.isEmpty()) {
            try {
                for (i2 = 0; i2 < elements.size(); ++i2) {
                    this.communalItems.getChildren().add((Object)this.getIEElement(elements.get(i2), i2));
                }
            }
            catch (FxInitException i2) {
                // empty catch block
            }
        }
        if (services != null && !services.isEmpty()) {
            try {
                this.communalItems.getChildren().add((Object)this.getElement(services.get(0), 0, true));
                for (i2 = 0; i2 < services.size(); ++i2) {
                    this.communalItems.getChildren().add((Object)this.getElement(services.get(i2), i2 + 1, false));
                }
            }
            catch (FxInitException fxInitException) {
                // empty catch block
            }
        }
        this.communalList.setVvalue(0.0);
    }

    private Node getIEElement(InputElement ie, int i) throws FxInitException {
        Node node = (Node)this.confirmItemCache.getObject("ie_item_" + i);
        Label title = this.searchLabel("elementTitle", node);
        Label value = this.searchLabel("elementValue", node);
        if (title != null && value != null) {
            if (ie.getKeyTitleId() != null && !ie.getKeyTitleId().isEmpty()) {
                this.getDynamicElements().add(new ScreenElement(new LabeledMessageTemplate((Labeled)title, "$lu.get(\"" + ie.getKeyTitleId() + "\")")));
            } else {
                title.setText(ie.getKeyTitle());
            }
            if (ie.getValueTitle() != null) {
                value.setText(ie.getValueTitle());
            } else {
                value.setText(ie.getValue());
            }
        }
        return node;
    }

    private Node getElement(Data data, int i, boolean title) throws FxInitException {
        Node node = (Node)this.confirmItemCache.getObject("item_" + i);
        node.getStyleClass().clear();
        this.processInfoLabels(node, data, title);
        Label label = (Label)node.lookup(".communal-item-label");
        Label sum = (Label)node.lookup("#summ");
        if (title) {
            node.getStyleClass().add((Object)"communal-item-title");
            this.getDynamicElements().add(new ScreenElement(new SupplierMessageTemplate(label.getText(), arg_0 -> ((Label)label).setText(arg_0))));
        } else {
            Optional.ofNullable(label).ifPresent(l -> l.setText(CommunalHelper.getTitle(data)));
            sum.setText(CommunalHelper.getSumTitle(data));
        }
        this.getDynamicElements().add(new ScreenElement(new SupplierMessageTemplate(sum.getText(), arg_0 -> ((Label)sum).setText(arg_0))));
        node.getStyleClass().add((Object)"communal-item");
        return node;
    }

    private void processInfoLabels(Node node, Data d, boolean title) {
        Label infL;
        ArrayList<Label> infoLabels = new ArrayList<Label>();
        for (int i = 0; i < 5 && (infL = (Label)node.lookup("#info" + i)) != null; ++i) {
            infL.setText(null);
            infoLabels.add(infL);
        }
        List<String> infoIdList = CommunalHelper.getInfoIdList(d);
        int end = infoLabels.size() < infoIdList.size() ? infoLabels.size() : infoIdList.size();
        for (int i = 0; i < end; ++i) {
            InputElement ie = CommunalHelper.getValue(infoIdList.get(i), d);
            if (ie == null) continue;
            if (title) {
                if (ie.getKeyTitle() != null && !ie.getKeyTitle().trim().isEmpty()) {
                    ((Label)infoLabels.get(i)).setText(ie.getKeyTitle());
                    continue;
                }
                ((Label)infoLabels.get(i)).setText(ie.getKey());
                continue;
            }
            ((Label)infoLabels.get(i)).setText(ie.getValueTitle() == null ? ie.getValue() : ie.getValueTitle());
        }
    }

    @Override
    public void setConfirmed(List<InputElement> elements) {
    }

    private static class ConfirmItemCache
    extends Cache<Node> {
        public ConfirmItemCache(int firstCount) {
            for (int i = 0; i < firstCount; ++i) {
                this.getObject("item_" + i);
                this.getObject("ie_item_" + i);
            }
        }

        @Override
        protected Node load(String path) {
            try {
                if (path.startsWith("item_")) {
                    return ResourceLoader.load(Locator.getUrl("/gui/skin/{name}/screen/pay/confirm/communal/item.fxml"), null);
                }
                return ResourceLoader.load(Locator.getUrl("/gui/skin/{name}/screen/pay/confirm/communal/ieitem.fxml"), null);
            }
            catch (Exception ex) {
                throw new RuntimeException("Can not load communalitem for InvariantCommunalTemplate : " + ex.getMessage());
            }
        }
    }
}

